/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.scala.basics;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.BatchTableEnvironment;
import org.apache.flink.table.api.bridge.scala.BatchTableEnvironment$;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.examples.scala.basics.TPCHQuery3Table;
import org.apache.flink.table.examples.scala.basics.TPCHQuery3Table$;
import org.apache.flink.table.expressions.Expression;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

public final class TPCHQuery3Table$ {
    public static TPCHQuery3Table$ MODULE$;
    private String lineitemPath;
    private String customerPath;
    private String ordersPath;
    private String outputPath;

    static {
        new TPCHQuery3Table$();
    }

    public void main(String[] args) {
        if (!this.parseParameters(args)) {
            return;
        }
        Expression date = (Expression)org.apache.flink.table.api.package$.MODULE$.LiteralStringExpression("1995-03-12").toDate();
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = BatchTableEnvironment$.MODULE$.create(env);
        Table lineitems = package$.MODULE$.dataSetConversions(this.getLineitemDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "extdPrice")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "discount")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipDate"))})).filter(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipDate")).toDate()).$greater(date));
        Table customers = package$.MODULE$.dataSetConversions(this.getCustomerDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mktSegment"))})).filter(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mktSegment")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.string2Literal("AUTOMOBILE")));
        Table orders = package$.MODULE$.dataSetConversions(this.getOrdersDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "custId")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipPrio"))})).filter(org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")).toDate()).$less(date));
        Table items = orders.join(customers).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "custId")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipPrio"))}).join(lineitems).where(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")).$eq$eq$eq(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")))).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")), org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "extdPrice")).$times(org.apache.flink.table.api.package$.MODULE$.WithOperations(org.apache.flink.table.api.package$.MODULE$.LiteralFloatExpression(1.0f).toExpr()).$minus(org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "discount"))))).as((Symbol)SymbolLiteral.bootstrap("apply", "revenue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipPrio"))});
        Table result = items.groupBy(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipPrio"))}).select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderId")), org.apache.flink.table.api.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "revenue")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "revenue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shipPrio"))}).orderBy(new Expression[]{(Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "revenue")).desc(), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "orderDate")).asc()});
        DataSet qual$1 = package$.MODULE$.table2RowDataSet(result);
        String x$1 = this.outputPath();
        String x$2 = "\n";
        String x$3 = "|";
        FileSystem.WriteMode x$4 = qual$1.writeAsCsv$default$4();
        qual$1.writeAsCsv(x$1, x$2, x$3, x$4);
        env.execute("Scala TPCH Query 3 (Table API Expression) Example");
    }

    private String lineitemPath() {
        return this.lineitemPath;
    }

    private void lineitemPath_$eq(String x$1) {
        this.lineitemPath = x$1;
    }

    private String customerPath() {
        return this.customerPath;
    }

    private void customerPath_$eq(String x$1) {
        this.customerPath = x$1;
    }

    private String ordersPath() {
        return this.ordersPath;
    }

    private void ordersPath_$eq(String x$1) {
        this.ordersPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length == 4) {
            this.lineitemPath_$eq(args[0]);
            this.customerPath_$eq(args[1]);
            this.ordersPath_$eq(args[2]);
            this.outputPath_$eq(args[3]);
            bl = true;
        } else {
            System.err.println("This program expects data from the TPC-H benchmark as input data.\n Due to legal restrictions, we can not ship generated data.\n You can find the TPC-H data generator at http://www.tpc.org/tpch/.\n Usage: TPCHQuery3 <lineitem-csv path> <customer-csv path> <orders-csv path> <result path>");
            bl = false;
        }
        return bl;
    }

    private DataSet<TPCHQuery3Table.Lineitem> getLineitemDataSet(ExecutionEnvironment env) {
        String x$5 = this.lineitemPath();
        String x$6 = "|";
        int[] x$7 = new int[]{0, 5, 6, 10};
        String x$8 = env.readCsvFile$default$2();
        Character x$9 = env.readCsvFile$default$4();
        boolean x$10 = env.readCsvFile$default$5();
        String x$11 = env.readCsvFile$default$6();
        boolean x$12 = env.readCsvFile$default$7();
        String[] x$13 = env.readCsvFile$default$9();
        return env.readCsvFile(x$5, x$8, x$6, x$9, x$10, x$11, x$12, x$7, x$13, ClassTag$.MODULE$.apply(TPCHQuery3Table.Lineitem.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3Table.Lineitem>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3Table.Lineitem> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<TPCHQuery3Table.Lineitem> unused = new ScalaCaseClassSerializer<TPCHQuery3Table.Lineitem>(this, fieldSerializers){

                    public TPCHQuery3Table.Lineitem createInstance(Object[] fields) {
                        return new TPCHQuery3Table.Lineitem(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), (String)fields[3]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.examples.scala.basics.TPCHQuery3Table$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    private DataSet<TPCHQuery3Table.Customer> getCustomerDataSet(ExecutionEnvironment env) {
        String x$14 = this.customerPath();
        String x$15 = "|";
        int[] x$16 = new int[]{0, 6};
        String x$17 = env.readCsvFile$default$2();
        Character x$18 = env.readCsvFile$default$4();
        boolean x$19 = env.readCsvFile$default$5();
        String x$20 = env.readCsvFile$default$6();
        boolean x$21 = env.readCsvFile$default$7();
        String[] x$22 = env.readCsvFile$default$9();
        return env.readCsvFile(x$14, x$17, x$15, x$18, x$19, x$20, x$21, x$16, x$22, ClassTag$.MODULE$.apply(TPCHQuery3Table.Customer.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3Table.Customer>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3Table.Customer> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<TPCHQuery3Table.Customer> unused = new ScalaCaseClassSerializer<TPCHQuery3Table.Customer>(this, fieldSerializers){

                    public TPCHQuery3Table.Customer createInstance(Object[] fields) {
                        return new TPCHQuery3Table.Customer(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.examples.scala.basics.TPCHQuery3Table$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    private DataSet<TPCHQuery3Table.Order> getOrdersDataSet(ExecutionEnvironment env) {
        String x$23 = this.ordersPath();
        String x$24 = "|";
        int[] x$25 = new int[]{0, 1, 4, 7};
        String x$26 = env.readCsvFile$default$2();
        Character x$27 = env.readCsvFile$default$4();
        boolean x$28 = env.readCsvFile$default$5();
        String x$29 = env.readCsvFile$default$6();
        boolean x$30 = env.readCsvFile$default$7();
        String[] x$31 = env.readCsvFile$default$9();
        return env.readCsvFile(x$23, x$26, x$24, x$27, x$28, x$29, x$30, x$25, x$31, ClassTag$.MODULE$.apply(TPCHQuery3Table.Order.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3Table.Order>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3Table.Order> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<TPCHQuery3Table.Order> unused = new ScalaCaseClassSerializer<TPCHQuery3Table.Order>(this, fieldSerializers){

                    public TPCHQuery3Table.Order createInstance(Object[] fields) {
                        return new TPCHQuery3Table.Order(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]), (String)fields[2], BoxesRunTime.unboxToLong((Object)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.examples.scala.basics.TPCHQuery3Table$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    private TPCHQuery3Table$() {
        MODULE$ = this;
    }
}

