/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.socket;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.util.Collector;

public class SocketWindowWordCount {
    public static void main(String[] args) throws Exception {
        int port;
        try {
            ParameterTool params = ParameterTool.fromArgs((String[])args);
            port = params.getInt("port");
        }
        catch (Exception e) {
            System.err.println("No port specified. Please run 'SocketWindowWordCount --port <port>', where port is the address of the text server");
            System.err.println("To start a simple text server, run 'netcat -l <port>' and type the input text into the command line");
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource text = env.socketTextStream("localhost", port, "\n");
        SingleOutputStreamOperator windowCounts = text.flatMap((FlatMapFunction)new FlatMapFunction<String, WordWithCount>(){

            public void flatMap(String value, Collector<WordWithCount> out) {
                for (String word : value.split("\\s")) {
                    out.collect((Object)new WordWithCount(word, 1L));
                }
            }
        }).keyBy(new String[]{"word"}).timeWindow(Time.seconds((long)5L), Time.seconds((long)1L)).reduce((ReduceFunction)new ReduceFunction<WordWithCount>(){

            public WordWithCount reduce(WordWithCount a, WordWithCount b) {
                return new WordWithCount(a.word, a.count + b.count);
            }
        });
        windowCounts.print().setParallelism(1);
        env.execute("Socket Window WordCount");
    }

    public static class WordWithCount {
        public String word;
        public long count;

        public WordWithCount() {
        }

        public WordWithCount(String word, long count) {
            this.word = word;
            this.count = count;
        }

        public String toString() {
            return this.word + " : " + this.count;
        }
    }
}

