/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.scala.examples.WindowJoinITCase$;
import org.apache.flink.streaming.scala.examples.join.WindowJoin;
import org.apache.flink.streaming.scala.examples.join.WindowJoin$;
import org.apache.flink.streaming.test.exampleJavaPrograms.join.WindowJoinData;
import org.apache.flink.streaming.util.StreamingMultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001\u001f\t\u0001r+\u001b8e_^Tu.\u001b8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001a=b[BdWm\u001d\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0013M$(/Z1nS:<'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0019\tA!\u001e;jY&\u0011QC\u0005\u0002\"'R\u0014X-Y7j]\u001elU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\t1\u0002^3tiB\u0013xn\u001a:b[R\ta\u0004\u0005\u0002 C5\t\u0001EC\u0001\u0006\u0013\t\u0011\u0003E\u0001\u0003V]&$\bFA\u000e%!\t)\u0003&D\u0001'\u0015\t9C\"A\u0003kk:LG/\u0003\u0002*M\t!A+Z:u\u0001")
public class WindowJoinITCase
extends StreamingMultipleProgramsTestBase {
    @Test
    public void testProgram() {
        String resultPath = File.createTempFile("result-path", "dir").toURI().toString();
        try {
            StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
            DataStream grades = env.fromCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])WindowJoinData.GRADES_INPUT.split("\n")), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Grade apply(String line) {
                    String[] fields = line.split(",");
                    return new WindowJoin.Grade(fields[1], new StringOps(Predef$.MODULE$.augmentString(fields[2])).toInt());
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Grade>(this){

                public TypeInformation<?>[] protected$types($anon$3 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<WindowJoin.Grade> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$3 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Grade>(this, fieldSerializers){

                        public WindowJoin.Grade createInstance(Object[] fields) {
                            return new WindowJoin.Grade((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]));
                        }
                    };
                }
            });
            DataStream salaries = env.fromCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])WindowJoinData.SALARIES_INPUT.split("\n")), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Salary apply(String line) {
                    String[] fields = line.split(",");
                    return new WindowJoin.Salary(fields[1], new StringOps(Predef$.MODULE$.augmentString(fields[2])).toInt());
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Salary>(this){

                public TypeInformation<?>[] protected$types($anon$4 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<WindowJoin.Salary> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$4 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Salary>(this, fieldSerializers){

                        public WindowJoin.Salary createInstance(Object[] fields) {
                            return new WindowJoin.Salary((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]));
                        }
                    };
                }
            });
            WindowJoin$.MODULE$.joinStreams(grades, salaries, 100L).writeAsText(resultPath, FileSystem.WriteMode.OVERWRITE);
            env.execute();
            TestBaseUtils.checkLinesAgainstRegexp((String)resultPath, (String)"^Person\\([a-z]+,(\\d),(\\d)+\\)");
        }
        catch (Throwable throwable) {
            try {
                FileUtils.deleteDirectory((File)new File(resultPath));
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        try {
            FileUtils.deleteDirectory((File)new File(resultPath));
        }
        catch (Throwable throwable) {}
    }
}

