/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.join;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.scala.examples.join.WindowJoin;
import org.apache.flink.streaming.scala.examples.join.WindowJoin$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class WindowJoin$ {
    public static final WindowJoin$ MODULE$;
    private final String[] names;
    private final int gradeCount;
    private final int salaryMax;
    private final int sleepInterval;

    static {
        new WindowJoin$();
    }

    public void main(String[] args) {
        DataStreamSink dataStreamSink;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        Predef$.MODULE$.println((Object)"Usage: WindowJoin --grades <path> --salaries <path> --output <path>");
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataStream<WindowJoin.Grade> grades = this.setGradesDataStream(env, params);
        DataStream<WindowJoin.Salary> salaries = this.setSalariesDataStream(env, params);
        DataStream joined = grades.join(salaries).where((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(WindowJoin.Grade x$1) {
                return x$1.name();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).equalTo((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(WindowJoin.Salary x$2) {
                return x$2.name();
            }
        }).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.seconds((long)2L), (Time)Time.seconds((long)1L))).apply((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowJoin.Person apply(WindowJoin.Grade g, WindowJoin.Salary s) {
                return new WindowJoin.Person(g.name(), g.grade(), s.salary());
            }
        }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Person>(){

            public TypeInformation<?>[] protected$types(anon.10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<WindowJoin.Person> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.10 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<WindowJoin.Person>(this, fieldSerializers){

                    public WindowJoin.Person createInstance(Object[] fields) {
                        return new WindowJoin.Person((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToInt((Object)fields[2]));
                    }
                };
            }
        });
        if (params.has("output")) {
            dataStreamSink = joined.writeAsText(params.get("output"));
        } else {
            Predef$.MODULE$.println((Object)"Printing result to stdout. Use --output to specify output path.");
            dataStreamSink = joined.print();
        }
        env.execute("WindowJoin");
    }

    public String[] names() {
        return this.names;
    }

    public int gradeCount() {
        return this.gradeCount;
    }

    public int salaryMax() {
        return this.salaryMax;
    }

    public int sleepInterval() {
        return this.sleepInterval;
    }

    public Stream<Tuple3<Object, String, Object>> gradeStream() {
        return (Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(int x) {
                return WindowJoin$.MODULE$.org$apache$flink$streaming$scala$examples$join$WindowJoin$$gradeMapper$1(WindowJoin$.MODULE$.names(), x);
            }
        }, package$.MODULE$.Stream().canBuildFrom());
    }

    public Stream<Tuple3<Object, String, Object>> salaryStream() {
        return (Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(int x) {
                return WindowJoin$.MODULE$.org$apache$flink$streaming$scala$examples$join$WindowJoin$$salaryMapper$1(x);
            }
        }, package$.MODULE$.Stream().canBuildFrom());
    }

    public Tuple3<Object, String, Object> parseMap(String line) {
        String[] record = line.substring(1, line.length() - 1).split(",");
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(record[0])).toLong()), (Object)record[1], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(record[2])).toInt()));
    }

    private DataStream<WindowJoin.Grade> setGradesDataStream(StreamExecutionEnvironment env, ParameterTool params) {
        DataStream dataStream;
        if (params.has("grades")) {
            dataStream = env.readTextFile(params.get("grades")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, String, Object> apply(String line) {
                    return WindowJoin$.MODULE$.parseMap(line);
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.11 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.11 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Grade apply(Tuple3<Object, String, Object> x) {
                    return new WindowJoin.Grade(BoxesRunTime.unboxToLong((Object)x._1()), (String)x._2(), BoxesRunTime.unboxToInt((Object)x._3()));
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Grade>(){

                public TypeInformation<?>[] protected$types(anon.12 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<WindowJoin.Grade> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.12 $outer;
                        private final ExecutionConfig executionConfig$3;
                        private final TypeSerializer[] fieldSerializers$3;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$3 = executionConfig$3;
                            this.fieldSerializers$3 = fieldSerializers$3;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Grade>(this, fieldSerializers){

                        public WindowJoin.Grade createInstance(Object[] fields) {
                            return new WindowJoin.Grade(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1], BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            });
        } else {
            Predef$.MODULE$.println((Object)"Executing WindowJoin example with default grades data set.");
            Predef$.MODULE$.println((Object)"Use --grades to specify file input.");
            dataStream = env.fromCollection(this.gradeStream(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.13 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.13 $outer;
                        private final ExecutionConfig executionConfig$4;
                        private final TypeSerializer[] fieldSerializers$4;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$4 = executionConfig$4;
                            this.fieldSerializers$4 = fieldSerializers$4;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Grade apply(Tuple3<Object, String, Object> x) {
                    return new WindowJoin.Grade(BoxesRunTime.unboxToLong((Object)x._1()), (String)x._2(), BoxesRunTime.unboxToInt((Object)x._3()));
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Grade>(){

                public TypeInformation<?>[] protected$types(anon.14 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<WindowJoin.Grade> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.14 $outer;
                        private final ExecutionConfig executionConfig$5;
                        private final TypeSerializer[] fieldSerializers$5;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$5 = executionConfig$5;
                            this.fieldSerializers$5 = fieldSerializers$5;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Grade>(this, fieldSerializers){

                        public WindowJoin.Grade createInstance(Object[] fields) {
                            return new WindowJoin.Grade(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1], BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            });
        }
        return dataStream;
    }

    private DataStream<WindowJoin.Salary> setSalariesDataStream(StreamExecutionEnvironment env, ParameterTool params) {
        DataStream dataStream;
        if (params.has("salaries")) {
            dataStream = env.readTextFile(params.get("salaries")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, String, Object> apply(String line) {
                    return WindowJoin$.MODULE$.parseMap(line);
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.15 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.15 $outer;
                        private final ExecutionConfig executionConfig$6;
                        private final TypeSerializer[] fieldSerializers$6;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$6 = executionConfig$6;
                            this.fieldSerializers$6 = fieldSerializers$6;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Salary apply(Tuple3<Object, String, Object> x) {
                    return new WindowJoin.Salary(BoxesRunTime.unboxToLong((Object)x._1()), (String)x._2(), BoxesRunTime.unboxToInt((Object)x._3()));
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Salary>(){

                public TypeInformation<?>[] protected$types(anon.16 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<WindowJoin.Salary> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.16 $outer;
                        private final ExecutionConfig executionConfig$7;
                        private final TypeSerializer[] fieldSerializers$7;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$7 = executionConfig$7;
                            this.fieldSerializers$7 = fieldSerializers$7;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Salary>(this, fieldSerializers){

                        public WindowJoin.Salary createInstance(Object[] fields) {
                            return new WindowJoin.Salary(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1], BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            });
        } else {
            Predef$.MODULE$.println((Object)"Executing WindowJoin example with default salaries data set.");
            Predef$.MODULE$.println((Object)"Use --salaries to specify file input.");
            dataStream = env.fromCollection(this.salaryStream(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.17 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.17 $outer;
                        private final ExecutionConfig executionConfig$8;
                        private final TypeSerializer[] fieldSerializers$8;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$8 = executionConfig$8;
                            this.fieldSerializers$8 = fieldSerializers$8;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Salary apply(Tuple3<Object, String, Object> x) {
                    return new WindowJoin.Salary(BoxesRunTime.unboxToLong((Object)x._1()), (String)x._2(), BoxesRunTime.unboxToInt((Object)x._3()));
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Salary>(){

                public TypeInformation<?>[] protected$types(anon.18 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<WindowJoin.Salary> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.18 $outer;
                        private final ExecutionConfig executionConfig$9;
                        private final TypeSerializer[] fieldSerializers$9;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$9[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$9);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$9 = executionConfig$9;
                            this.fieldSerializers$9 = fieldSerializers$9;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Salary>(this, fieldSerializers){

                        public WindowJoin.Salary createInstance(Object[] fields) {
                            return new WindowJoin.Salary(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1], BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            });
        }
        return dataStream;
    }

    public final Tuple3 org$apache$flink$streaming$scala$examples$join$WindowJoin$$gradeMapper$1(String[] names, int x) {
        if (x % this.sleepInterval() == 0) {
            Thread.sleep(this.sleepInterval());
        }
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()), (Object)names[Random$.MODULE$.nextInt(names.length)], (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(this.gradeCount())));
    }

    public final Tuple3 org$apache$flink$streaming$scala$examples$join$WindowJoin$$salaryMapper$1(int x) {
        if (x % this.sleepInterval() == 0) {
            Thread.sleep(this.sleepInterval());
        }
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()), (Object)this.names()[Random$.MODULE$.nextInt(this.names().length)], (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(this.salaryMax())));
    }

    private WindowJoin$() {
        MODULE$ = this;
        this.names = (String[])((Object[])new String[]{"tom", "jerry", "alice", "bob", "john", "grace"});
        this.gradeCount = 5;
        this.salaryMax = 10000;
        this.sleepInterval = 100;
    }
}

