/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.twitter;

import java.util.StringTokenizer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.json.JSONParseFlatMap;
import org.apache.flink.streaming.connectors.twitter.TwitterSource;
import org.apache.flink.streaming.examples.twitter.util.TwitterStreamData;
import org.apache.flink.util.Collector;
import org.apache.sling.commons.json.JSONException;

public class TwitterStream {
    public static void main(String[] args) throws Exception {
        DataStreamSource streamSource;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        System.out.println("Usage: TwitterStream --output <path> --props <path>");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        if (params.has("props")) {
            streamSource = env.addSource((SourceFunction)new TwitterSource(params.get("props")));
        } else {
            System.out.println("Executing TwitterStream example with default props.");
            System.out.println("Use --props to specify the path to the authentication info.");
            streamSource = env.fromElements((Object[])TwitterStreamData.TEXTS);
        }
        SingleOutputStreamOperator tweets = streamSource.flatMap((FlatMapFunction)new SelectEnglishAndTokenizeFlatMap()).keyBy(new int[]{0}).sum(1);
        if (params.has("output")) {
            tweets.writeAsText(params.get("output"));
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            tweets.print();
        }
        env.execute("Twitter Streaming Example");
    }

    public static class SelectEnglishAndTokenizeFlatMap
    extends JSONParseFlatMap<String, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) throws Exception {
            try {
                if (this.getString(value, "user.lang").equals("en")) {
                    StringTokenizer tokenizer = new StringTokenizer(this.getString(value, "text"));
                    while (tokenizer.hasMoreTokens()) {
                        String result = tokenizer.nextToken().replaceAll("\\s*", "").toLowerCase();
                        if (result.equals("")) continue;
                        out.collect((Object)new Tuple2((Object)result, (Object)1));
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

