/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.socket;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.examples.wordcount.WordCount;

public class SocketTextStreamWordCount {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        if (!params.has("hostname") || !params.has("port")) {
            System.err.println("Usage: SocketTextStreamWordCount --hostname <name> --port <n> [--output <path>]");
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataStreamSource text = env.socketTextStream(params.get("hostname"), params.getInt("port"), '\n', 0L);
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new WordCount.Tokenizer()).keyBy(new int[]{0}).sum(1);
        if (params.has("output")) {
            counts.writeAsText(params.get("output"));
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            counts.print();
        }
        env.execute("WordCount from SocketTextStream Example");
    }
}

