/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.kafka;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer08;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.streaming.util.serialization.SimpleStringSchema;

public class ReadFromKafka {
    public static void main(String[] args) throws Exception {
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        if (parameterTool.getNumberOfParameters() < 3) {
            System.out.println("Missing parameters!\nUsage: Kafka --topic <topic> --bootstrap.servers <kafka brokers> --group.id <some id>");
            System.exit(1);
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().disableSysoutLogging();
        env.getConfig().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)4, (long)10000L));
        env.enableCheckpointing(5000L);
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)parameterTool);
        DataStreamSource messageStream = env.addSource((SourceFunction)new FlinkKafkaConsumer08(parameterTool.getRequired("topic"), (DeserializationSchema)new SimpleStringSchema(), parameterTool.getProperties()));
        messageStream.print();
        env.execute("Read from Kafka example");
    }
}

