/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.relational;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.AggregateDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.JoinDataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.scala.relational.TPCHQuery3;
import org.apache.flink.examples.scala.relational.TPCHQuery3$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TPCHQuery3$ {
    public static final TPCHQuery3$ MODULE$;

    static {
        new TPCHQuery3$();
    }

    public void main(String[] args) {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        if (params.has("lineitem") || params.has("customer") || params.has("orders")) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat.parse("1995-03-12");
            DataSet lineitems = this.getLineitemDataSet(env, params.get("lineitem")).filter((Function1)new Serializable(dateFormat, date){
                public static final long serialVersionUID = 0L;
                private final SimpleDateFormat dateFormat$1;
                private final Date date$1;

                public final boolean apply(TPCHQuery3.Lineitem l) {
                    return this.dateFormat$1.parse(l.shipDate()).after(this.date$1);
                }
                {
                    this.dateFormat$1 = dateFormat$1;
                    this.date$1 = date$1;
                }
            });
            DataSet customers = this.getCustomerDataSet(env, params.get("customer")).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(TPCHQuery3.Customer c) {
                    return c.mktSegment().equals("AUTOMOBILE");
                }
            });
            DataSet<TPCHQuery3.Order> orders = this.getOrdersDataSet(env, params.get("order"));
            DataSet items = ((JoinDataSet)((JoinDataSet)orders.filter((Function1)new Serializable(dateFormat, date){
                public static final long serialVersionUID = 0L;
                private final SimpleDateFormat dateFormat$1;
                private final Date date$1;

                public final boolean apply(TPCHQuery3.Order o) {
                    return this.dateFormat$1.parse(o.orderDate()).before(this.date$1);
                }
                {
                    this.dateFormat$1 = dateFormat$1;
                    this.date$1 = date$1;
                }
            }).join(customers).where("custId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).equalTo("custId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).apply((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TPCHQuery3.Order apply(TPCHQuery3.Order o, TPCHQuery3.Customer c) {
                    return o;
                }
            }, (TypeInformation)new CaseClassTypeInfo<TPCHQuery3.Order>(){

                public TypeInformation<?>[] protected$types(anon.6 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<TPCHQuery3.Order> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.6 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<TPCHQuery3.Order>(this, fieldSerializers){

                        public TPCHQuery3.Order createInstance(Object[] fields) {
                            return new TPCHQuery3.Order(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]), (String)fields[2], BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(TPCHQuery3.Order.class)).join(lineitems).where("orderId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).equalTo("orderId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).apply((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TPCHQuery3.ShippedItem apply(TPCHQuery3.Order o, TPCHQuery3.Lineitem l) {
                    return new TPCHQuery3.ShippedItem(o.orderId(), l.extdPrice() * (1.0 - l.discount()), o.orderDate(), o.shipPrio());
                }
            }, (TypeInformation)new CaseClassTypeInfo<TPCHQuery3.ShippedItem>(){

                public TypeInformation<?>[] protected$types(anon.7 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<TPCHQuery3.ShippedItem> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.7 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<TPCHQuery3.ShippedItem>(this, fieldSerializers){

                        public TPCHQuery3.ShippedItem createInstance(Object[] fields) {
                            return new TPCHQuery3.ShippedItem(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), (String)fields[2], BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(TPCHQuery3.ShippedItem.class));
            AggregateDataSet result = items.groupBy("orderId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orderDate", "shipPrio"})).aggregate(Aggregations.SUM, "revenue");
            if (params.has("output")) {
                result.writeAsCsv(params.get("output"), "\n", "|", result.writeAsCsv$default$4());
                env.execute("Scala TPCH Query 3 Example");
            } else {
                Predef$.MODULE$.println((Object)"Printing result to stdout. Use --output to specify output path.");
                result.print();
            }
            return;
        }
        Predef$.MODULE$.println((Object)"  This program expects data from the TPC-H benchmark as input data.");
        Predef$.MODULE$.println((Object)"  Due to legal restrictions, we can not ship generated data.");
        Predef$.MODULE$.println((Object)"  You can find the TPC-H data generator at http://www.tpc.org/tpch/.");
        Predef$.MODULE$.println((Object)"  Usage: TPCHQuery3 --lineitem <path> --customer <path> --orders <path> [--output <path>]");
    }

    private DataSet<TPCHQuery3.Lineitem> getLineitemDataSet(ExecutionEnvironment env, String lineitemPath) {
        String x$1 = lineitemPath;
        String x$2 = "|";
        int[] x$3 = new int[]{0, 5, 6, 10};
        String x$4 = env.readCsvFile$default$2();
        Character x$5 = env.readCsvFile$default$4();
        boolean x$6 = env.readCsvFile$default$5();
        String x$7 = env.readCsvFile$default$6();
        boolean x$8 = env.readCsvFile$default$7();
        String[] x$9 = env.readCsvFile$default$9();
        return env.readCsvFile(x$1, x$4, x$2, x$5, x$6, x$7, x$8, x$3, x$9, ClassTag$.MODULE$.apply(TPCHQuery3.Lineitem.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3.Lineitem>(){

            public TypeInformation<?>[] protected$types(anon.8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3.Lineitem> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.8 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                return new CaseClassSerializer<TPCHQuery3.Lineitem>(this, fieldSerializers){

                    public TPCHQuery3.Lineitem createInstance(Object[] fields) {
                        return new TPCHQuery3.Lineitem(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), (String)fields[3]);
                    }
                };
            }
        });
    }

    private DataSet<TPCHQuery3.Customer> getCustomerDataSet(ExecutionEnvironment env, String customerPath) {
        String x$10 = customerPath;
        String x$11 = "|";
        int[] x$12 = new int[]{0, 6};
        String x$13 = env.readCsvFile$default$2();
        Character x$14 = env.readCsvFile$default$4();
        boolean x$15 = env.readCsvFile$default$5();
        String x$16 = env.readCsvFile$default$6();
        boolean x$17 = env.readCsvFile$default$7();
        String[] x$18 = env.readCsvFile$default$9();
        return env.readCsvFile(x$10, x$13, x$11, x$14, x$15, x$16, x$17, x$12, x$18, ClassTag$.MODULE$.apply(TPCHQuery3.Customer.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3.Customer>(){

            public TypeInformation<?>[] protected$types(anon.9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3.Customer> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.9 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                return new CaseClassSerializer<TPCHQuery3.Customer>(this, fieldSerializers){

                    public TPCHQuery3.Customer createInstance(Object[] fields) {
                        return new TPCHQuery3.Customer(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1]);
                    }
                };
            }
        });
    }

    private DataSet<TPCHQuery3.Order> getOrdersDataSet(ExecutionEnvironment env, String ordersPath) {
        String x$19 = ordersPath;
        String x$20 = "|";
        int[] x$21 = new int[]{0, 1, 4, 7};
        String x$22 = env.readCsvFile$default$2();
        Character x$23 = env.readCsvFile$default$4();
        boolean x$24 = env.readCsvFile$default$5();
        String x$25 = env.readCsvFile$default$6();
        boolean x$26 = env.readCsvFile$default$7();
        String[] x$27 = env.readCsvFile$default$9();
        return env.readCsvFile(x$19, x$22, x$20, x$23, x$24, x$25, x$26, x$21, x$27, ClassTag$.MODULE$.apply(TPCHQuery3.Order.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3.Order>(){

            public TypeInformation<?>[] protected$types(anon.10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3.Order> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.10 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                return new CaseClassSerializer<TPCHQuery3.Order>(this, fieldSerializers){

                    public TPCHQuery3.Order createInstance(Object[] fields) {
                        return new TPCHQuery3.Order(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]), (String)fields[2], BoxesRunTime.unboxToLong((Object)fields[3]));
                    }
                };
            }
        });
    }

    private TPCHQuery3$() {
        MODULE$ = this;
    }
}

