/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.ml;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.examples.java.ml.util.LinearRegressionData;

public class LinearRegression {
    public static void main(String[] args) throws Exception {
        DataSource data;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        int iterations = params.getInt("iterations", 10);
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        if (params.has("input")) {
            data = env.readCsvFile(params.get("input")).fieldDelimiter(" ").includeFields(new boolean[]{true, true}).pojoType(Data.class, new String[0]);
        } else {
            System.out.println("Executing LinearRegression example with default input data set.");
            System.out.println("Use --input to specify file input.");
            data = LinearRegressionData.getDefaultDataDataSet(env);
        }
        DataSet<Params> parameters = LinearRegressionData.getDefaultParamsDataSet(env);
        IterativeDataSet loop = parameters.iterate(iterations);
        MapOperator new_parameters = ((MapOperator)data.map((MapFunction)new SubUpdate()).withBroadcastSet((DataSet)loop, "parameters")).reduce((ReduceFunction)new UpdateAccumulator()).map((MapFunction)new Update());
        DataSet result = loop.closeWith((DataSet)new_parameters);
        if (params.has("output")) {
            result.writeAsText(params.get("output"));
            env.execute("Linear Regression example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            result.print();
        }
    }

    public static class Update
    implements MapFunction<Tuple2<Params, Integer>, Params> {
        public Params map(Tuple2<Params, Integer> arg0) throws Exception {
            return ((Params)arg0.f0).div((Integer)arg0.f1);
        }
    }

    public static class UpdateAccumulator
    implements ReduceFunction<Tuple2<Params, Integer>> {
        public Tuple2<Params, Integer> reduce(Tuple2<Params, Integer> val1, Tuple2<Params, Integer> val2) {
            double new_theta0 = ((Params)val1.f0).theta0 + ((Params)val2.f0).theta0;
            double new_theta1 = ((Params)val1.f0).theta1 + ((Params)val2.f0).theta1;
            Params result = new Params(new_theta0, new_theta1);
            return new Tuple2((Object)result, (Object)((Integer)val1.f1 + (Integer)val2.f1));
        }
    }

    public static class SubUpdate
    extends RichMapFunction<Data, Tuple2<Params, Integer>> {
        private Collection<Params> parameters;
        private Params parameter;
        private int count = 1;

        public void open(Configuration parameters) throws Exception {
            this.parameters = this.getRuntimeContext().getBroadcastVariable("parameters");
        }

        public Tuple2<Params, Integer> map(Data in) throws Exception {
            Iterator<Params> iterator = this.parameters.iterator();
            while (iterator.hasNext()) {
                Params p;
                this.parameter = p = iterator.next();
            }
            double theta_0 = this.parameter.theta0 - 0.01 * (this.parameter.theta0 + this.parameter.theta1 * in.x - in.y);
            double theta_1 = this.parameter.theta1 - 0.01 * ((this.parameter.theta0 + this.parameter.theta1 * in.x - in.y) * in.x);
            return new Tuple2((Object)new Params(theta_0, theta_1), (Object)this.count);
        }
    }

    public static class Params
    implements Serializable {
        private double theta0;
        private double theta1;

        public Params() {
        }

        public Params(double x0, double x1) {
            this.theta0 = x0;
            this.theta1 = x1;
        }

        public String toString() {
            return this.theta0 + " " + this.theta1;
        }

        public double getTheta0() {
            return this.theta0;
        }

        public double getTheta1() {
            return this.theta1;
        }

        public void setTheta0(double theta0) {
            this.theta0 = theta0;
        }

        public void setTheta1(double theta1) {
            this.theta1 = theta1;
        }

        public Params div(Integer a) {
            this.theta0 /= (double)a.intValue();
            this.theta1 /= (double)a.intValue();
            return this;
        }
    }

    public static class Data
    implements Serializable {
        public double x;
        public double y;

        public Data() {
        }

        public Data(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + "|" + this.y + ")";
        }
    }
}

