/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.changelog.fs.OutputStreamWithPos;
import org.apache.flink.changelog.fs.StateChangeFormat;
import org.apache.flink.changelog.fs.StateChangeSet;
import org.apache.flink.changelog.fs.StateChangeUploader;
import org.apache.flink.changelog.fs.UploadResult;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.shaded.guava30.com.google.common.io.Closer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateChangeFsUploader
implements StateChangeUploader {
    private static final Logger LOG = LoggerFactory.getLogger(StateChangeFsUploader.class);
    private final Path basePath;
    private final FileSystem fileSystem;
    private final StateChangeFormat format;
    private final boolean compression;
    private final int bufferSize;

    public StateChangeFsUploader(Path basePath, FileSystem fileSystem, boolean compression, int bufferSize) {
        this.basePath = basePath;
        this.fileSystem = fileSystem;
        this.format = new StateChangeFormat();
        this.compression = compression;
        this.bufferSize = bufferSize;
    }

    @Override
    public void upload(StateChangeUploader.UploadTask uploadTask) throws IOException {
        this.upload(Collections.singletonList(uploadTask));
    }

    @Override
    public void upload(Collection<StateChangeUploader.UploadTask> tasks) throws IOException {
        String fileName = this.generateFileName();
        LOG.debug("upload {} tasks to {}", (Object)tasks.size(), (Object)fileName);
        Path path = new Path(this.basePath, fileName);
        try {
            LocalResult result = this.upload(path, tasks);
            result.tasksOffsets.forEach((task, offsets) -> task.complete(this.buildResults(result.handle, (Map<StateChangeSet, Long>)offsets)));
        }
        catch (IOException e) {
            try (Closer closer = Closer.create();){
                closer.register(() -> {
                    throw e;
                });
                tasks.forEach(cs -> closer.register(() -> cs.fail(e)));
                closer.register(() -> this.fileSystem.delete(path, true));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private LocalResult upload(Path path, Collection<StateChangeUploader.UploadTask> tasks) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputStreamWithPos wrap(FSDataOutputStream fsStream) throws IOException {
        StreamCompressionDecorator instance = this.compression ? SnappyStreamCompressionDecorator.INSTANCE : UncompressedStreamCompressionDecorator.INSTANCE;
        FSDataOutputStream compressed = this.compression ? instance.decorateWithCompression((OutputStream)fsStream) : fsStream;
        return new OutputStreamWithPos(new BufferedOutputStream((OutputStream)compressed, this.bufferSize));
    }

    private List<UploadResult> buildResults(StreamStateHandle handle, Map<StateChangeSet, Long> offsets) {
        return offsets.entrySet().stream().map(e -> UploadResult.of(handle, (StateChangeSet)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
    }

    private String generateFileName() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void close() {
    }

    private static final class LocalResult {
        private final Map<StateChangeUploader.UploadTask, Map<StateChangeSet, Long>> tasksOffsets;
        private final StreamStateHandle handle;

        public LocalResult(Map<StateChangeUploader.UploadTask, Map<StateChangeSet, Long>> tasksOffsets, StreamStateHandle handle) {
            this.tasksOffsets = tasksOffsets;
            this.handle = handle;
        }
    }
}

