/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.File;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.changelog.fs.FsStateChangelogOptions;
import org.apache.flink.changelog.fs.FsStateChangelogStorage;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageFactory;

@Internal
public class FsStateChangelogStorageFactory
implements StateChangelogStorageFactory {
    public static final String IDENTIFIER = "filesystem";

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public StateChangelogStorage<?> createStorage(Configuration configuration) throws IOException {
        return new FsStateChangelogStorage(configuration);
    }

    public static void configure(Configuration configuration, File newFolder) {
        configuration.setString(CheckpointingOptions.STATE_CHANGE_LOG_STORAGE, IDENTIFIER);
        configuration.setString(FsStateChangelogOptions.BASE_PATH, newFolder.getAbsolutePath());
    }
}

