/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import org.apache.flink.changelog.fs.StateChangeSet;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.util.Preconditions;

final class UploadResult {
    public final StreamStateHandle streamStateHandle;
    public final long offset;
    public final SequenceNumber sequenceNumber;
    public final long size;

    public UploadResult(StreamStateHandle streamStateHandle, long offset, SequenceNumber sequenceNumber, long size) {
        this.streamStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)streamStateHandle);
        this.offset = offset;
        this.sequenceNumber = (SequenceNumber)Preconditions.checkNotNull((Object)sequenceNumber);
        this.size = size;
    }

    public static UploadResult of(StreamStateHandle handle, StateChangeSet changeSet, long offset) {
        return new UploadResult(handle, offset, changeSet.getSequenceNumber(), changeSet.getSize());
    }

    public StreamStateHandle getStreamStateHandle() {
        return this.streamStateHandle;
    }

    public long getOffset() {
        return this.offset;
    }

    public SequenceNumber getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "streamStateHandle=" + this.streamStateHandle + ", size=" + this.size + ", offset=" + this.offset + ", sequenceNumber=" + this.sequenceNumber;
    }
}

