/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;

public final class CsvRowSchemaConverter {
    private static final HashSet<TypeInformation<?>> NUMBER_TYPES = new HashSet<TypeInformation>(Arrays.asList(Types.BYTE, Types.SHORT, Types.INT, Types.LONG, Types.DOUBLE, Types.FLOAT, Types.BIG_DEC, Types.BIG_INT));
    private static final HashSet<TypeInformation<?>> STRING_TYPES = new HashSet<TypeInformation>(Arrays.asList(Types.STRING, Types.SQL_DATE, Types.SQL_TIME, Types.SQL_TIMESTAMP));
    private static final HashSet<TypeInformation<?>> BOOLEAN_TYPES = new HashSet<TypeInformation>(Arrays.asList(Types.BOOLEAN, Types.VOID));

    private CsvRowSchemaConverter() {
    }

    public static CsvSchema convert(RowTypeInfo rowType) {
        CsvSchema.Builder builder = new CsvSchema.Builder();
        String[] fields = rowType.getFieldNames();
        TypeInformation[] types = rowType.getFieldTypes();
        for (int i = 0; i < rowType.getArity(); ++i) {
            builder.addColumn(new CsvSchema.Column(i, fields[i], CsvRowSchemaConverter.convertType(fields[i], types[i])));
        }
        return builder.build();
    }

    private static CsvSchema.ColumnType convertType(String fieldName, TypeInformation<?> info) {
        if (STRING_TYPES.contains(info)) {
            return CsvSchema.ColumnType.STRING;
        }
        if (NUMBER_TYPES.contains(info)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (BOOLEAN_TYPES.contains(info)) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (info instanceof ObjectArrayTypeInfo) {
            CsvRowSchemaConverter.validateNestedField(fieldName, ((ObjectArrayTypeInfo)info).getComponentInfo());
            return CsvSchema.ColumnType.ARRAY;
        }
        if (info instanceof BasicArrayTypeInfo) {
            CsvRowSchemaConverter.validateNestedField(fieldName, ((BasicArrayTypeInfo)info).getComponentInfo());
            return CsvSchema.ColumnType.ARRAY;
        }
        if (info instanceof RowTypeInfo) {
            TypeInformation[] types;
            for (TypeInformation type : types = ((RowTypeInfo)info).getFieldTypes()) {
                CsvRowSchemaConverter.validateNestedField(fieldName, type);
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        if (info instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)info).getComponentType() == Types.BYTE) {
            return CsvSchema.ColumnType.STRING;
        }
        throw new IllegalArgumentException("Unsupported type information '" + info.toString() + "' for field '" + fieldName + "'.");
    }

    private static void validateNestedField(String fieldName, TypeInformation<?> info) {
        if (!(NUMBER_TYPES.contains(info) || STRING_TYPES.contains(info) || BOOLEAN_TYPES.contains(info))) {
            throw new IllegalArgumentException("Only simple types are supported in the second level nesting of fields '" + fieldName + "' but was: " + info);
        }
    }
}

