/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.ClassLoaderUtil;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FlinkUserCodeClassLoadersTest {
    @TempDir
    private static Path tempFolder;
    public static final String USER_CLASS = "UserClass";
    public static final String USER_CLASS_CODE = "import java.io.Serializable;\npublic class UserClass implements Serializable {}";
    private static File userJar;

    FlinkUserCodeClassLoadersTest() {
    }

    @BeforeAll
    static void prepare() throws Exception {
        userJar = UserClassLoaderJarTestUtils.createJarFile(TempDirUtils.newFolder((Path)tempFolder, (String[])new String[]{"test-jar"}), "test-classloader.jar", USER_CLASS, USER_CLASS_CODE);
    }

    @Test
    void testParentFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, parentClassLoader);
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader1);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader2);
        Assertions.assertThat(clazz2).isEqualTo(clazz1);
        Assertions.assertThat(clazz3).isEqualTo(clazz1);
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    void testChildFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader1);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader2);
        Assertions.assertThat(clazz2).isNotEqualTo(clazz1);
        Assertions.assertThat(clazz3).isNotEqualTo(clazz1);
        Assertions.assertThat(clazz3).isNotEqualTo(clazz2);
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    void testRepeatedChildFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz4 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Assertions.assertThat(clazz2).isNotEqualTo(clazz1);
        Assertions.assertThat(clazz3).isEqualTo(clazz2);
        Assertions.assertThat(clazz4).isEqualTo(clazz2);
        childClassLoader.close();
    }

    @Test
    void testRepeatedParentFirstPatternClass() throws Exception {
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        String parentFirstPattern = className.substring(0, className.lastIndexOf(46));
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[]{parentFirstPattern}, (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz4 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Assertions.assertThat(clazz2).isEqualTo(clazz1);
        Assertions.assertThat(clazz3).isEqualTo(clazz1);
        Assertions.assertThat(clazz4).isEqualTo(clazz1);
        childClassLoader.close();
    }

    @Test
    void testGetClassLoaderInfo() throws Exception {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        String formattedURL = ClassLoaderUtil.formatURL((URL)childCodePath);
        Assertions.assertThat((String)("URL ClassLoader:" + formattedURL)).isEqualTo(ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)childClassLoader));
        childClassLoader.close();
    }

    @Test
    void testGetClassLoaderInfoWithClassLoaderClosed() throws Exception {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        childClassLoader.close();
        Assertions.assertThat((String)ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)childClassLoader)).startsWith((CharSequence)"Cannot access classloader info due to an exception.");
    }

    private static MutableURLClassLoader createParentFirstClassLoader(URL childCodePath, ClassLoader parentClassLoader) {
        return FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
    }

    private static MutableURLClassLoader createChildFirstClassLoader(URL childCodePath, ClassLoader parentClassLoader) {
        return FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[0], (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
    }

    @Test
    void testClosingOfClassloader() throws Exception {
        String className = ClassToLoad.class.getName();
        ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        Class<?> loadedClass = childClassLoader.loadClass(className);
        Assertions.assertThat(loadedClass).isNotSameAs(ClassToLoad.class);
        childClassLoader.close();
        Assertions.assertThatThrownBy(() -> FlinkUserCodeClassLoadersTest.lambda$testClosingOfClassloader$0((URLClassLoader)childClassLoader, className)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testParallelCapable() {
        Assertions.assertThat((boolean)TestParentFirstClassLoader.isParallelCapable).isTrue();
    }

    @Test
    void testParentFirstClassLoadingByAddURL() throws Exception {
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader parentClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, this.getClass().getClassLoader());
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader1);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader2);
        parentClassLoader.addURL(userJar.toURI().toURL());
        Class<?> clazz1 = Class.forName(USER_CLASS, false, (ClassLoader)parentClassLoader);
        Class<?> clazz2 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader1);
        Class<?> clazz3 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader2);
        Assertions.assertThat(clazz2).isEqualTo(clazz1);
        Assertions.assertThat(clazz3).isEqualTo(clazz1);
        parentClassLoader.close();
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    void testChildFirstClassLoadingByAddURL() throws Exception {
        URL childCodePath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader parentClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, this.getClass().getClassLoader());
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader1);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader2);
        URL userJarURL = userJar.toURI().toURL();
        childClassLoader1.addURL(userJarURL);
        childClassLoader2.addURL(userJarURL);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)parentClassLoader);
        Class<?> clazz1 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader1);
        Class<?> clazz2 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader2);
        Assertions.assertThat(clazz2).isNotEqualTo(clazz1);
        parentClassLoader.close();
        childClassLoader1.close();
        childClassLoader2.close();
    }

    private void assertClassNotFoundException(String className, boolean initialize, ClassLoader classLoader) {
        Assertions.assertThatThrownBy(() -> Class.forName(className, initialize, classLoader)).isInstanceOf(ClassNotFoundException.class);
    }

    private static /* synthetic */ void lambda$testClosingOfClassloader$0(URLClassLoader childClassLoader, String className) throws Throwable {
        childClassLoader.loadClass(className);
    }

    private static class ClassToLoad {
        private ClassToLoad() {
        }
    }

    private static class TestParentFirstClassLoader
    extends FlinkUserCodeClassLoaders.ParentFirstClassLoader {
        public static boolean isParallelCapable = ClassLoader.registerAsParallelCapable();

        TestParentFirstClassLoader() {
            super(null, null, null);
        }
    }
}

