/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.parser.StringValueParser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VarLengthStringParserTest {
    public StringValueParser parser = new StringValueParser();

    VarLengthStringParserTest() {
    }

    @Test
    void testGetValue() {
        StringValue v = this.parser.createValue();
        Assertions.assertThat((Object)v).isInstanceOf(StringValue.class);
    }

    @Test
    void testParseValidUnquotedStrings() {
        this.parser = new StringValueParser();
        byte[] recBytes = "abcdefgh|i|jklmno|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(9);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcdefgh");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(11);
        Assertions.assertThat((String)s.getValue()).isEqualTo("i");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(18);
        Assertions.assertThat((String)s.getValue()).isEqualTo("jklmno");
        recBytes = "abcde".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(5);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde");
        recBytes = "abcde|fg".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(6);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(8);
        Assertions.assertThat((String)s.getValue()).isEqualTo("fg");
    }

    @Test
    void testParseValidQuotedStrings() {
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)34);
        byte[] recBytes = "\"abcdefgh\"|\"i\"|\"jklmno\"|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(11);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcdefgh");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(15);
        Assertions.assertThat((String)s.getValue()).isEqualTo("i");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(24);
        Assertions.assertThat((String)s.getValue()).isEqualTo("jklmno");
        recBytes = "\"abcde\"".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(7);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde");
        recBytes = "\"abcde\"|\"fg\"".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(8);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(12);
        Assertions.assertThat((String)s.getValue()).isEqualTo("fg");
        recBytes = "\"abcde|fg\"|\"hij|kl|mn|op\"|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(11);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde|fg");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(26);
        Assertions.assertThat((String)s.getValue()).isEqualTo("hij|kl|mn|op");
        recBytes = "\"abcde|fg\"|\"hij|kl|mn|op\"".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(11);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde|fg");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(25);
        Assertions.assertThat((String)s.getValue()).isEqualTo("hij|kl|mn|op");
    }

    @Test
    void testParseValidMixedStrings() {
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)64);
        byte[] recBytes = "@abcde|gh@|@i@|jklmnopq|@rs@|tuv".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(11);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde|gh");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(15);
        Assertions.assertThat((String)s.getValue()).isEqualTo("i");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(24);
        Assertions.assertThat((String)s.getValue()).isEqualTo("jklmnopq");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(29);
        Assertions.assertThat((String)s.getValue()).isEqualTo("rs");
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(32);
        Assertions.assertThat((String)s.getValue()).isEqualTo("tuv");
    }

    @Test
    void testParseInvalidQuotedStrings() {
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)34);
        byte[] recBytes = "\"abcdefgh\"-|\"jklmno  ".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isNegative();
        startPos = 12;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isNegative();
    }

    @Test
    void testParseValidMixedStringsWithCharset() {
        Charset charset = StandardCharsets.US_ASCII;
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)64);
        byte[] recBytes = "@abcde|gh@|@i@|jklmnopq|@rs@|tuv".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        this.parser.setCharset(charset);
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assertions.assertThat((int)startPos).isEqualTo(11);
        Assertions.assertThat((String)s.getValue()).isEqualTo("abcde|gh");
    }
}

