/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.FloatValue;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.FloatValueParser;
import org.apache.flink.types.parser.ParserTestBase;

class FloatValueParserTest
extends ParserTestBase<FloatValue> {
    FloatValueParserTest() {
    }

    @Override
    public String[] getValidTestValues() {
        return new String[]{"0", "0.0", "123.4", "0.124", ".623", "1234", "-12.34", String.valueOf(Float.MAX_VALUE), String.valueOf(Float.MIN_VALUE), String.valueOf(Float.NEGATIVE_INFINITY), String.valueOf(Float.POSITIVE_INFINITY), String.valueOf(Float.NaN), "1.234E2", "1.234e3", "1.234E-2", "1239"};
    }

    public FloatValue[] getValidTestResults() {
        return new FloatValue[]{new FloatValue(0.0f), new FloatValue(0.0f), new FloatValue(123.4f), new FloatValue(0.124f), new FloatValue(0.623f), new FloatValue(1234.0f), new FloatValue(-12.34f), new FloatValue(Float.MAX_VALUE), new FloatValue(Float.MIN_VALUE), new FloatValue(Float.NEGATIVE_INFINITY), new FloatValue(Float.POSITIVE_INFINITY), new FloatValue(Float.NaN), new FloatValue(123.4f), new FloatValue(1234.0f), new FloatValue(0.01234f), new FloatValue(1239.0f)};
    }

    @Override
    public String[] getInvalidTestValues() {
        return new String[]{"a", "123abc4", "-57-6", "7-877678", " 1", "2 ", " ", "\t"};
    }

    @Override
    public boolean allowsEmptyField() {
        return false;
    }

    @Override
    public FieldParser<FloatValue> getParser() {
        return new FloatValueParser();
    }

    @Override
    public Class<FloatValue> getTypeClass() {
        return FloatValue.class;
    }
}

