/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NormalizableKeyTest {
    NormalizableKeyTest() {
    }

    @Test
    void testIntValue() {
        IntValue int0 = new IntValue(10);
        IntValue int1 = new IntValue(10);
        IntValue int2 = new IntValue(-10);
        IntValue int3 = new IntValue(255);
        IntValue int4 = new IntValue(Integer.MAX_VALUE);
        IntValue int5 = new IntValue(2139095040);
        IntValue int6 = new IntValue(Integer.MIN_VALUE);
        IntValue int7 = new IntValue(Integer.MIN_VALUE);
        for (int length = 2; length <= 4; ++length) {
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int1, length);
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int2, length);
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int3, length);
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int4, length);
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int5, length);
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int6, length);
            this.assertNormalizableKey((NormalizableKey)int0, (NormalizableKey)int7, length);
            this.assertNormalizableKey((NormalizableKey)int4, (NormalizableKey)int5, length);
            this.assertNormalizableKey((NormalizableKey)int6, (NormalizableKey)int7, length);
        }
    }

    @Test
    void testLongValue() {
        LongValue long0 = new LongValue(10L);
        LongValue long1 = new LongValue(10L);
        LongValue long2 = new LongValue(-10L);
        LongValue long3 = new LongValue(255L);
        LongValue long4 = new LongValue(Long.MAX_VALUE);
        LongValue long5 = new LongValue(9187343239835811840L);
        LongValue long6 = new LongValue(Long.MIN_VALUE);
        LongValue long7 = new LongValue(Long.MIN_VALUE);
        for (int length = 2; length <= 8; ++length) {
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long1, length);
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long2, length);
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long3, length);
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long4, length);
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long5, length);
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long6, length);
            this.assertNormalizableKey((NormalizableKey)long0, (NormalizableKey)long7, length);
            this.assertNormalizableKey((NormalizableKey)long4, (NormalizableKey)long5, length);
            this.assertNormalizableKey((NormalizableKey)long6, (NormalizableKey)long7, length);
        }
    }

    @Test
    void testStringValue() {
        StringValue string0 = new StringValue((CharSequence)"This is a test");
        StringValue string1 = new StringValue((CharSequence)"This is a test with some longer String");
        StringValue string2 = new StringValue((CharSequence)"This is a tesa");
        StringValue string3 = new StringValue((CharSequence)"This");
        StringValue string4 = new StringValue((CharSequence)"\u00dcnlaut \u00dftring \u00b5 avec \u00e9 y \u00a2");
        for (int length = 5; length <= 15; length += 10) {
            this.assertNormalizableKey((NormalizableKey)string0, (NormalizableKey)string1, length);
            this.assertNormalizableKey((NormalizableKey)string0, (NormalizableKey)string2, length);
            this.assertNormalizableKey((NormalizableKey)string0, (NormalizableKey)string3, length);
            this.assertNormalizableKey((NormalizableKey)string0, (NormalizableKey)string4, length);
        }
    }

    @Test
    void testPactNull() {
        NullValue pn1 = new NullValue();
        NullValue pn2 = new NullValue();
        this.assertNormalizableKey((NormalizableKey)pn1, (NormalizableKey)pn2, 0);
    }

    @Test
    void testPactChar() {
        CharValue c1 = new CharValue('\u0000');
        CharValue c2 = new CharValue('\u0001');
        CharValue c3 = new CharValue('\u00ff');
        CharValue c4 = new CharValue('\uffff');
        CharValue c5 = new CharValue('\u0000');
        CharValue c6 = new CharValue('\udbff');
        CharValue c7 = new CharValue('\udfff');
        CharValue c8 = new CharValue('\udfff');
        CharValue[] allChars = new CharValue[]{c1, c2, c3, c4, c5, c6, c7, c8};
        for (int i = 0; i < 5; ++i) {
            for (CharValue allChar1 : allChars) {
                for (CharValue allChar : allChars) {
                    this.assertNormalizableKey((NormalizableKey)allChar1, (NormalizableKey)allChar, i);
                }
            }
        }
    }

    private <T extends Comparable<T>> void assertNormalizableKey(NormalizableKey<T> key1, NormalizableKey<T> key2, int len) {
        byte[] normalizedKeys = new byte[32];
        MemorySegment wrapper = MemorySegmentFactory.wrap((byte[])normalizedKeys);
        key1.copyNormalizedKey(wrapper, 0, len);
        key2.copyNormalizedKey(wrapper, len, len);
        for (int i = 0; i < len; ++i) {
            int normKey1 = normalizedKeys[i] & 0xFF;
            int normKey2 = normalizedKeys[len + i] & 0xFF;
            int comp = normKey1 - normKey2;
            if (comp == 0) continue;
            Assertions.assertThat((Math.signum(key1.compareTo(key2)) != Math.signum(comp) ? 1 : 0) != 0).isFalse().describedAs("Normalized key comparison differs from actual key comparison", new Object[0]);
            return;
        }
        Assertions.assertThat((key1.compareTo(key2) == 0 || key1.getMaxNormalizedKeyLen() > len ? 1 : 0) != 0).isTrue();
    }
}

