/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.ArrayList;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.JavaToValueConverter;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JavaToValueConverterTest {
    JavaToValueConverterTest() {
    }

    @Test
    void testJavaToValueConversion() {
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType(null)).isNull();
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)"123Test")).isEqualTo((Object)new StringValue((CharSequence)"123Test"));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)44)).isEqualTo((Object)new ByteValue(44));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)10000)).isEqualTo((Object)new ShortValue(10000));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)3567564)).isEqualTo((Object)new IntValue(3567564));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)767692734L)).isEqualTo((Object)new LongValue(767692734L));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)Float.valueOf(17.5f))).isEqualTo((Object)new FloatValue(17.5f));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)3.1415926)).isEqualTo((Object)new DoubleValue(3.1415926));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)true)).isEqualTo((Object)new BooleanValue(true));
        Assertions.assertThat((Object)JavaToValueConverter.convertBoxedJavaType((Object)Character.valueOf('@'))).isEqualTo((Object)new CharValue('@'));
        Assertions.assertThatThrownBy(() -> JavaToValueConverter.convertBoxedJavaType(new ArrayList())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValueToJavaConversion() {
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType(null)).isNull();
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new StringValue((CharSequence)"123Test"))).isEqualTo((Object)"123Test");
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new ByteValue(44))).isEqualTo((Object)44);
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new ShortValue(10000))).isEqualTo((Object)10000);
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new IntValue(3567564))).isEqualTo((Object)3567564);
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new LongValue(767692734L))).isEqualTo((Object)767692734L);
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new FloatValue(17.5f))).isEqualTo((Object)Float.valueOf(17.5f));
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new DoubleValue(3.1415926))).isEqualTo((Object)3.1415926);
        Assertions.assertThat((Boolean)((Boolean)JavaToValueConverter.convertValueType((Value)new BooleanValue(true)))).isTrue();
        Assertions.assertThat((Object)JavaToValueConverter.convertValueType((Value)new CharValue('@'))).isEqualTo((Object)Character.valueOf('@'));
        Assertions.assertThatThrownBy(() -> JavaToValueConverter.convertValueType((Value)new MyValue())).isInstanceOf(IllegalArgumentException.class);
    }

    private static final class MyValue
    implements Value {
        private static final long serialVersionUID = 1L;

        private MyValue() {
        }

        public void write(DataOutputView out) {
        }

        public void read(DataInputView in) {
        }
    }
}

