/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.fs.AbstractAutoCloseableRegistryTest;
import org.apache.flink.core.fs.ClosingFSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.core.fs.WrappingProxyCloseable;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.util.AbstractAutoCloseableRegistry;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SafetyNetCloseableRegistryTest
extends AbstractAutoCloseableRegistryTest<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef> {
    @TempDir
    public File tmpFolder;

    SafetyNetCloseableRegistryTest() {
    }

    @Override
    protected void registerCloseable(final Closeable closeable) throws IOException {
        WrappingProxyCloseable<Closeable> wrappingProxyCloseable = new WrappingProxyCloseable<Closeable>(){

            public void close() throws IOException {
                closeable.close();
            }

            public Closeable getWrappedDelegate() {
                return closeable;
            }
        };
        this.closeableRegistry.registerCloseable((AutoCloseable)wrappingProxyCloseable);
    }

    @Override
    protected AbstractAutoCloseableRegistry<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef, IOException> createRegistry() {
        return new SafetyNetCloseableRegistry(() -> new JoinOnInterruptReaperThread());
    }

    @Override
    protected AbstractAutoCloseableRegistryTest.ProducerThread<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef> createProducerThread(AbstractAutoCloseableRegistry<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef, IOException> registry, AtomicInteger unclosedCounter, int maxStreams) {
        return new AbstractAutoCloseableRegistryTest.ProducerThread<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef>(registry, unclosedCounter, maxStreams){
            int count;
            {
                this.count = 0;
            }

            @Override
            protected void createAndRegisterStream() throws IOException {
                String debug = Thread.currentThread().getName() + " " + this.count;
                AbstractAutoCloseableRegistryTest.TestStream testStream = new AbstractAutoCloseableRegistryTest.TestStream(this.refCount);
                ClosingFSDataInputStream pis = ClosingFSDataInputStream.wrapSafe((FSDataInputStream)testStream, (SafetyNetCloseableRegistry)((SafetyNetCloseableRegistry)this.registry), (String)debug);
                ++this.count;
            }
        };
    }

    @AfterEach
    void tearDown() {
        Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isFalse();
    }

    @Test
    void testCorrectScopesForSafetyNet() throws Exception {
        CheckedThread t1 = new CheckedThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void go() throws Exception {
                FileSystem fs1 = FileSystem.getLocalFileSystem();
                Assertions.assertThat((Object)fs1).isNotInstanceOf(SafetyNetWrapperFileSystem.class);
                FileSystemSafetyNet.initializeSafetyNetForThread();
                fs1 = FileSystem.getLocalFileSystem();
                Assertions.assertThat((Object)fs1).isInstanceOf(SafetyNetWrapperFileSystem.class);
                Path tmp = new Path(SafetyNetCloseableRegistryTest.newFolder(SafetyNetCloseableRegistryTest.this.tmpFolder, new String[]{"junit"}).toURI().toString(), "test_file");
                try (FSDataOutputStream stream = fs1.create(tmp, FileSystem.WriteMode.NO_OVERWRITE);){
                    CheckedThread t2 = new CheckedThread(){

                        public void go() {
                            FileSystem fs2 = FileSystem.getLocalFileSystem();
                            Assertions.assertThat((Object)fs2).isNotInstanceOf(SafetyNetWrapperFileSystem.class);
                            FileSystemSafetyNet.initializeSafetyNetForThread();
                            fs2 = FileSystem.getLocalFileSystem();
                            Assertions.assertThat((Object)fs2).isInstanceOf(SafetyNetWrapperFileSystem.class);
                            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                            fs2 = FileSystem.getLocalFileSystem();
                            Assertions.assertThat((Object)fs2).isNotInstanceOf(SafetyNetWrapperFileSystem.class);
                        }
                    };
                    t2.start();
                    t2.sync();
                    stream.write(42);
                    FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                    Assertions.assertThatThrownBy(() -> stream.write(43)).isInstanceOf(IOException.class);
                    fs1 = FileSystem.getLocalFileSystem();
                    Assertions.assertThat((Object)fs1).isNotInstanceOf(SafetyNetWrapperFileSystem.class);
                }
                finally {
                    fs1.delete(tmp, false);
                }
            }
        };
        t1.start();
        t1.sync();
    }

    @Test
    void testSafetyNetClose() throws Exception {
        this.setup(20);
        this.startThreads();
        this.joinThreads();
        for (int i = 0; i < 5 && this.unclosedCounter.get() > 0; ++i) {
            System.gc();
            Thread.sleep(50L);
        }
        Assertions.assertThat((AtomicInteger)this.unclosedCounter).hasValue(0);
        this.closeableRegistry.close();
    }

    @Test
    void testReaperThreadSpawnAndStop() throws Exception {
        Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isFalse();
        try (SafetyNetCloseableRegistry ignored = new SafetyNetCloseableRegistry();){
            Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isTrue();
            try (SafetyNetCloseableRegistry ignored2 = new SafetyNetCloseableRegistry();){
                Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isTrue();
            }
            Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isTrue();
        }
        Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isFalse();
    }

    @Test
    void testReaperThreadStartFailed() throws Exception {
        try {
            new SafetyNetCloseableRegistry(() -> new OutOfMemoryReaperThread());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isFalse();
        SafetyNetCloseableRegistry closeableRegistry = new SafetyNetCloseableRegistry();
        Assertions.assertThat((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning()).isTrue();
        closeableRegistry.close();
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }

    private static class OutOfMemoryReaperThread
    extends SafetyNetCloseableRegistry.CloseableReaperThread {
        private OutOfMemoryReaperThread() {
        }

        public synchronized void start() {
            throw new OutOfMemoryError();
        }

        private static File newFolder(File root, String ... subDirs) throws IOException {
            String subFolder = String.join((CharSequence)"/", subDirs);
            File result = new File(root, subFolder);
            if (!result.mkdirs()) {
                throw new IOException("Couldn't create folders " + root);
            }
            return result;
        }
    }

    private static class JoinOnInterruptReaperThread
    extends SafetyNetCloseableRegistry.CloseableReaperThread {
        private JoinOnInterruptReaperThread() {
        }

        public void interrupt() {
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        private static File newFolder(File root, String ... subDirs) throws IOException {
            String subFolder = String.join((CharSequence)"/", subDirs);
            File result = new File(root, subFolder);
            if (!result.mkdirs()) {
                throw new IOException("Couldn't create folders " + root);
            }
            return result;
        }
    }
}

