/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoPojosForMigrationTests;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KryoSerializerSnapshotTest {
    private SerializerConfigImpl oldConfig;
    private SerializerConfigImpl newConfig;

    @BeforeEach
    void setup() {
        this.oldConfig = new SerializerConfigImpl();
        this.newConfig = new SerializerConfigImpl();
    }

    @Test
    void sanityTest() {
        Assertions.assertThat(KryoSerializerSnapshotTest.resolveKryoCompatibility(this.oldConfig, this.newConfig)).is(TypeSerializerConditions.isCompatibleAsIs());
    }

    @Test
    void addingTypesIsCompatibleAfterReconfiguration() {
        this.oldConfig.registerKryoType(KryoPojosForMigrationTests.Animal.class);
        this.newConfig.registerKryoType(KryoPojosForMigrationTests.Animal.class);
        this.newConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogKryoSerializer.class);
        Assertions.assertThat(KryoSerializerSnapshotTest.resolveKryoCompatibility(this.oldConfig, this.newConfig)).is(TypeSerializerConditions.isCompatibleWithReconfiguredSerializer());
    }

    @Test
    void replacingKryoSerializersIsCompatibleAsIs() {
        this.oldConfig.registerKryoType(KryoPojosForMigrationTests.Animal.class);
        this.oldConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogKryoSerializer.class);
        this.newConfig.registerKryoType(KryoPojosForMigrationTests.Animal.class);
        this.newConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogV2KryoSerializer.class);
        Assertions.assertThat(KryoSerializerSnapshotTest.resolveKryoCompatibility(this.oldConfig, this.newConfig)).is(TypeSerializerConditions.isCompatibleAsIs());
    }

    @Test
    void reorderingIsCompatibleAfterReconfiguration() {
        this.oldConfig.registerKryoType(KryoPojosForMigrationTests.Parrot.class);
        this.oldConfig.registerKryoType(KryoPojosForMigrationTests.Dog.class);
        this.newConfig.registerKryoType(KryoPojosForMigrationTests.Dog.class);
        this.newConfig.registerKryoType(KryoPojosForMigrationTests.Parrot.class);
        Assertions.assertThat(KryoSerializerSnapshotTest.resolveKryoCompatibility(this.oldConfig, this.newConfig)).is(TypeSerializerConditions.isCompatibleWithReconfiguredSerializer());
    }

    @Test
    void tryingToRestoreWithNonExistingClassShouldBeIncompatible() throws IOException {
        TypeSerializerSnapshot<KryoPojosForMigrationTests.Animal> restoredSnapshot = KryoSerializerSnapshotTest.kryoSnapshotWithMissingClass();
        KryoSerializer currentSerializer = new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)new SerializerConfigImpl());
        Assertions.assertThat((Object)currentSerializer.snapshotConfiguration().resolveSchemaCompatibility(restoredSnapshot)).is(TypeSerializerConditions.isIncompatible());
    }

    private static TypeSerializerSnapshot<KryoPojosForMigrationTests.Animal> kryoSnapshotWithMissingClass() throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(KryoSerializerSnapshotTest.unLoadableSnapshotBytes());
        return TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)KryoSerializerSnapshotTest.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] unLoadableSnapshotBytes() throws IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderUtils.ObjectAndClassLoader<Serializable> outsideClassLoading = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(outsideClassLoading.getClassLoader());
            SerializerConfigImpl conf = new SerializerConfigImpl();
            conf.registerKryoType(outsideClassLoading.getObject().getClass());
            KryoSerializer previousSerializer = new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)conf);
            TypeSerializerSnapshot previousSnapshot = previousSerializer.snapshotConfiguration();
            DataOutputSerializer out = new DataOutputSerializer(4096);
            TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, (TypeSerializerSnapshot)previousSnapshot);
            byte[] byArray = out.getCopyOfBuffer();
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal> resolveKryoCompatibility(SerializerConfigImpl previous, SerializerConfigImpl current) {
        KryoSerializer previousSerializer = new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)previous);
        TypeSerializerSnapshot previousSnapshot = previousSerializer.snapshotConfiguration();
        KryoSerializer currentSerializer = new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)current);
        return currentSerializer.snapshotConfiguration().resolveSchemaCompatibility(previousSnapshot);
    }
}

