/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.EitherSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.Either;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class EitherSerializerTest {
    EitherSerializerTest() {
    }

    @Test
    void testStringDoubleEither() {
        Either[] testData = new Either[]{Either.Left((Object)"banana"), Either.Left((Object)""), Either.Right((Object)32.0), Either.Right((Object)Double.MIN_VALUE), Either.Right((Object)Double.MAX_VALUE)};
        EitherTypeInfo eitherTypeInfo = new EitherTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.DOUBLE_TYPE_INFO);
        EitherSerializer eitherSerializer = (EitherSerializer)eitherTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        EitherSerializerTestInstance<Either> testInstance = new EitherSerializerTestInstance<Either>((TypeSerializer<Either>)eitherSerializer, (Class<Either>)eitherTypeInfo.getTypeClass(), -1, (T[])testData);
        testInstance.testAll();
    }

    @Test
    void testStringValueDoubleValueEither() {
        Either[] testData = new Either[]{Either.Left((Object)new StringValue((CharSequence)"banana")), Either.Left.of((Object)new StringValue((CharSequence)"apple")), new Either.Left((Object)new StringValue((CharSequence)"")), Either.Right((Object)new DoubleValue(32.0)), Either.Right.of((Object)new DoubleValue(Double.MIN_VALUE)), new Either.Right((Object)new DoubleValue(Double.MAX_VALUE))};
        EitherTypeInfo eitherTypeInfo = new EitherTypeInfo((TypeInformation)ValueTypeInfo.STRING_VALUE_TYPE_INFO, (TypeInformation)ValueTypeInfo.DOUBLE_VALUE_TYPE_INFO);
        EitherSerializer eitherSerializer = (EitherSerializer)eitherTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        EitherSerializerTestInstance<Either> testInstance = new EitherSerializerTestInstance<Either>((TypeSerializer<Either>)eitherSerializer, (Class<Either>)eitherTypeInfo.getTypeClass(), -1, (T[])testData);
        testInstance.testAll();
    }

    @Test
    void testEitherWithTuple() {
        Either[] testData = new Either[]{Either.Left((Object)new Tuple2((Object)2L, (Object)9L)), new Either.Left((Object)new Tuple2((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE)), new Either.Right((Object)32.0), Either.Right((Object)Double.MIN_VALUE), Either.Right((Object)Double.MAX_VALUE)};
        EitherTypeInfo eitherTypeInfo = new EitherTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO}), (TypeInformation)BasicTypeInfo.DOUBLE_TYPE_INFO);
        EitherSerializer eitherSerializer = (EitherSerializer)eitherTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        EitherSerializerTestInstance<Either> testInstance = new EitherSerializerTestInstance<Either>((TypeSerializer<Either>)eitherSerializer, (Class<Either>)eitherTypeInfo.getTypeClass(), -1, (T[])testData);
        testInstance.testAll();
    }

    @Test
    void testEitherWithTupleValues() {
        Either[] testData = new Either[]{Either.Left((Object)new Tuple2((Object)new LongValue(2L), (Object)new LongValue(9L))), new Either.Left((Object)new Tuple2((Object)new LongValue(Long.MIN_VALUE), (Object)new LongValue(Long.MAX_VALUE))), new Either.Right((Object)new DoubleValue(32.0)), Either.Right((Object)new DoubleValue(Double.MIN_VALUE)), Either.Right((Object)new DoubleValue(Double.MAX_VALUE))};
        EitherTypeInfo eitherTypeInfo = new EitherTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{ValueTypeInfo.LONG_VALUE_TYPE_INFO, ValueTypeInfo.LONG_VALUE_TYPE_INFO}), (TypeInformation)ValueTypeInfo.DOUBLE_VALUE_TYPE_INFO);
        EitherSerializer eitherSerializer = (EitherSerializer)eitherTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        EitherSerializerTestInstance<Either> testInstance = new EitherSerializerTestInstance<Either>((TypeSerializer<Either>)eitherSerializer, (Class<Either>)eitherTypeInfo.getTypeClass(), -1, (T[])testData);
        testInstance.testAll();
    }

    @Test
    void testEitherWithObjectReuse() {
        EitherTypeInfo eitherTypeInfo = new EitherTypeInfo((TypeInformation)ValueTypeInfo.LONG_VALUE_TYPE_INFO, (TypeInformation)ValueTypeInfo.DOUBLE_VALUE_TYPE_INFO);
        EitherSerializer eitherSerializer = (EitherSerializer)eitherTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        LongValue lv = new LongValue();
        DoubleValue dv = new DoubleValue();
        Either left = Either.Left((Object)lv);
        Either right = Either.Right((Object)dv);
        Either copy0 = eitherSerializer.copy(left, right);
        Either copy1 = eitherSerializer.copy(right, copy0);
        Either copy2 = eitherSerializer.copy(left, copy1);
        Assertions.assertThat((Object)copy1).isSameAs((Object)right);
        Assertions.assertThat((Object)copy2).isSameAs((Object)copy0);
        Assertions.assertThat((Comparable)((Comparable)copy1.right())).isSameAs(right.right());
        Assertions.assertThat((Comparable)((Comparable)copy2.left())).isSameAs(copy0.left());
    }

    @Test
    void testSerializeIndividually() throws IOException {
        EitherTypeInfo eitherTypeInfo = new EitherTypeInfo((TypeInformation)ValueTypeInfo.LONG_VALUE_TYPE_INFO, (TypeInformation)ValueTypeInfo.DOUBLE_VALUE_TYPE_INFO);
        EitherSerializer eitherSerializer = (EitherSerializer)eitherTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        LongValue lv = new LongValue();
        DoubleValue dv = new DoubleValue();
        Either left = Either.Left((Object)lv);
        Either right = Either.Right((Object)dv);
        ComparatorTestBase.TestOutputView out = new ComparatorTestBase.TestOutputView();
        eitherSerializer.serialize(left, (DataOutputView)out);
        eitherSerializer.serialize(right, (DataOutputView)out);
        eitherSerializer.serialize(left, (DataOutputView)out);
        ComparatorTestBase.TestInputView in = out.getInputView();
        Either copy0 = eitherSerializer.deserialize(right, (DataInputView)in);
        Either copy1 = eitherSerializer.deserialize(copy0, (DataInputView)in);
        Either copy2 = eitherSerializer.deserialize(copy1, (DataInputView)in);
        Assertions.assertThat((Object)copy1).isSameAs((Object)right);
        Assertions.assertThat((Object)copy2).isSameAs((Object)copy0);
        Assertions.assertThat((Comparable)((Comparable)copy1.right())).isSameAs(right.right());
        Assertions.assertThat((Comparable)((Comparable)copy2.left())).isSameAs(copy0.left());
    }

    @Nested
    private class EitherSerializerTestInstance<T>
    extends SerializerTestInstance<T> {
        public EitherSerializerTestInstance(TypeSerializer<T> serializer, Class<T> typeClass, int length, T[] testData) {
            super(serializer, typeClass, length, testData);
        }

        @Override
        @Test
        protected void testInstantiate() {
            TypeSerializer serializer = this.getSerializer();
            Object instance = serializer.createInstance();
            ((ObjectAssert)Assertions.assertThat((Object)instance).as("The created instance must not be null.", new Object[0])).isNotNull();
            Class type = this.getTypeClass();
            ((ClassAssert)Assertions.assertThat(type).as("The test is corrupt: type class is null.", new Object[0])).isNotNull();
        }
    }
}

