/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.time.Instant;
import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.InstantSerializer;

class InstantSerializerTest
extends SerializerTestBase<Instant> {
    InstantSerializerTest() {
    }

    @Override
    protected TypeSerializer<Instant> createSerializer() {
        return new InstantSerializer();
    }

    @Override
    protected int getLength() {
        return 12;
    }

    @Override
    protected Class<Instant> getTypeClass() {
        return Instant.class;
    }

    private static long rndSeconds(Random rnd) {
        return (long)((double)Instant.MIN.getEpochSecond() + rnd.nextDouble() * (double)(Instant.MAX.getEpochSecond() - Instant.MIN.getEpochSecond()));
    }

    private static int rndNanos(Random rnd) {
        return (int)(rnd.nextDouble() * 9.99999999E8);
    }

    protected Instant[] getTestData() {
        Random rnd = new Random(874597969123412341L);
        return new Instant[]{Instant.EPOCH, Instant.MIN, Instant.MAX, Instant.ofEpochSecond(InstantSerializerTest.rndSeconds(rnd), InstantSerializerTest.rndNanos(rnd)), Instant.ofEpochSecond(1534135584L, 949495L), Instant.ofEpochSecond(56090783L)};
    }
}

