/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.Random;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.FloatComparator;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;

class FloatComparatorTest
extends ComparatorTestBase<Float> {
    FloatComparatorTest() {
    }

    @Override
    protected TypeComparator<Float> createComparator(boolean ascending) {
        return new FloatComparator(ascending);
    }

    @Override
    protected TypeSerializer<Float> createSerializer() {
        return new FloatSerializer();
    }

    protected Float[] getSortedTestData() {
        Random rnd = new Random(874597969123412338L);
        float rndFloat = rnd.nextFloat();
        if (rndFloat < 0.0f) {
            rndFloat = -rndFloat;
        }
        if (rndFloat == Float.MAX_VALUE) {
            rndFloat -= 3.0f;
        }
        if (rndFloat <= 2.0f) {
            rndFloat += 3.0f;
        }
        return new Float[]{Float.valueOf(-rndFloat), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(rndFloat), Float.valueOf(Float.MAX_VALUE)};
    }
}

