/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.configuration.MemorySize;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlotSharingGroupTest {
    SlotSharingGroupTest() {
    }

    @Test
    void testBuildSlotSharingGroupWithSpecificResource() {
        String name = "ssg";
        MemorySize heap = MemorySize.ofMebiBytes((long)100L);
        MemorySize offHeap = MemorySize.ofMebiBytes((long)200L);
        MemorySize managed = MemorySize.ofMebiBytes((long)300L);
        SlotSharingGroup slotSharingGroup = SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(1.0).setTaskHeapMemory(heap).setTaskOffHeapMemory(offHeap).setManagedMemory(managed).setExternalResource("gpu", 1.0).build();
        Assertions.assertThat((String)slotSharingGroup.getName()).isEqualTo("ssg");
        Assertions.assertThat((Optional)slotSharingGroup.getCpuCores()).hasValue((Object)1.0);
        Assertions.assertThat((Optional)slotSharingGroup.getTaskHeapMemory()).hasValue((Object)heap);
        Assertions.assertThat((Optional)slotSharingGroup.getTaskOffHeapMemory()).hasValue((Object)offHeap);
        Assertions.assertThat((Optional)slotSharingGroup.getManagedMemory()).hasValue((Object)managed);
        Assertions.assertThat((Map)slotSharingGroup.getExternalResources()).isEqualTo(Collections.singletonMap("gpu", 1.0));
    }

    @Test
    void testBuildSlotSharingGroupWithUnknownResource() {
        String name = "ssg";
        SlotSharingGroup slotSharingGroup = SlotSharingGroup.newBuilder((String)"ssg").build();
        Assertions.assertThat((String)slotSharingGroup.getName()).isEqualTo("ssg");
        Assertions.assertThat((Optional)slotSharingGroup.getCpuCores()).isNotPresent();
        Assertions.assertThat((Optional)slotSharingGroup.getTaskHeapMemory()).isNotPresent();
        Assertions.assertThat((Optional)slotSharingGroup.getManagedMemory()).isNotPresent();
        Assertions.assertThat((Optional)slotSharingGroup.getTaskOffHeapMemory()).isNotPresent();
        Assertions.assertThat((Map)slotSharingGroup.getExternalResources()).isEmpty();
    }

    @Test
    void testBuildSlotSharingGroupWithIllegalConfig() {
        Assertions.assertThatThrownBy(() -> SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(1.0).setTaskHeapMemory(MemorySize.ZERO).setTaskOffHeapMemoryMB(10).build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testBuildSlotSharingGroupWithoutAllRequiredConfig() {
        Assertions.assertThatThrownBy(() -> SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(1.0).setTaskOffHeapMemoryMB(10).build()).isInstanceOf(IllegalArgumentException.class);
    }
}

