/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceSpecTest {
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    ResourceSpecTest() {
    }

    @Test
    void testLessThanOrEqualWhenBothSpecified() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assertions.assertThat((boolean)rs1.lessThanOrEqual(rs2)).isTrue();
        Assertions.assertThat((boolean)rs2.lessThanOrEqual(rs1)).isTrue();
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        Assertions.assertThat((boolean)rs1.lessThanOrEqual(rs3)).isTrue();
        Assertions.assertThat((boolean)rs3.lessThanOrEqual(rs1)).isFalse();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        Assertions.assertThat((boolean)rs4.lessThanOrEqual(rs3)).isFalse();
        Assertions.assertThat((boolean)rs3.lessThanOrEqual(rs4)).isTrue();
    }

    @Test
    void testLessThanOrEqualWhenBothUnknown() {
        Assertions.assertThat((boolean)ResourceSpec.UNKNOWN.lessThanOrEqual(ResourceSpec.UNKNOWN)).isTrue();
    }

    @Test
    void testLessThanOrEqualWhenUnknownWithSpecified() {
        Assertions.assertThatThrownBy(() -> ResourceSpec.UNKNOWN.lessThanOrEqual(ResourceSpec.newBuilder((double)1.0, (int)100).build())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testLessThanOrEqualWhenSpecifiedWithUnknown() {
        Assertions.assertThatThrownBy(() -> ResourceSpec.newBuilder((double)1.0, (int)100).build().lessThanOrEqual(ResourceSpec.UNKNOWN)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testEquals() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assertions.assertThat((Object)rs2).isEqualTo((Object)rs1);
        Assertions.assertThat((Object)rs1).isEqualTo((Object)rs2);
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((Object)rs4).isNotEqualTo((Object)rs3);
        ResourceSpec rs5 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        Assertions.assertThat((Object)rs5).isEqualTo((Object)rs3);
    }

    @Test
    void testHashCode() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        Assertions.assertThat((Object)rs2).hasSameHashCodeAs((Object)rs1);
        ResourceSpec rs3 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((int)rs4.hashCode()).isNotEqualTo(rs3.hashCode());
        ResourceSpec rs5 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2)).build();
        Assertions.assertThat((Object)rs5).hasSameHashCodeAs((Object)rs3);
    }

    @Test
    void testMerge() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs3 = rs1.merge(rs2);
        Assertions.assertThat((Comparable)rs3.getCpuCores()).isEqualTo((Object)new CPUResource(2.0));
        Assertions.assertThat((int)rs3.getTaskHeapMemory().getMebiBytes()).isEqualTo(200);
        Assertions.assertThat((Optional)rs3.getExtendedResource(EXTERNAL_RESOURCE_NAME)).hasValue((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1));
        ResourceSpec rs4 = rs1.merge(rs3);
        Assertions.assertThat((Optional)rs4.getExtendedResource(EXTERNAL_RESOURCE_NAME)).hasValue((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.2));
    }

    @Test
    void testSerializable() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)rs1);
        Assertions.assertThat((Object)rs2).isEqualTo((Object)rs1);
    }

    @Test
    void testMergeThisUnknown() {
        ResourceSpec spec1 = ResourceSpec.UNKNOWN;
        ResourceSpec spec2 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec merged = spec1.merge(spec2);
        Assertions.assertThat((Object)merged).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testMergeOtherUnknown() {
        ResourceSpec spec1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec spec2 = ResourceSpec.UNKNOWN;
        ResourceSpec merged = spec1.merge(spec2);
        Assertions.assertThat((Object)merged).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testMergeBothUnknown() {
        ResourceSpec spec1 = ResourceSpec.UNKNOWN;
        ResourceSpec spec2 = ResourceSpec.UNKNOWN;
        ResourceSpec merged = spec1.merge(spec2);
        Assertions.assertThat((Object)merged).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testMergeWithSerializationCopy() throws Exception {
        ResourceSpec spec1 = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        ResourceSpec spec2 = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        ResourceSpec merged = spec1.merge(spec2);
        Assertions.assertThat((Object)merged).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testSingletonPropertyOfUnknown() throws Exception {
        ResourceSpec copiedSpec = (ResourceSpec)CommonTestUtils.createCopySerializable((Serializable)ResourceSpec.UNKNOWN);
        Assertions.assertThat((Object)copiedSpec).isSameAs((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testSubtract() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)0.2, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.5)).build();
        ResourceSpec subtracted = rs1.subtract(rs2);
        Assertions.assertThat((Comparable)subtracted.getCpuCores()).isEqualTo((Object)new CPUResource(0.8));
        Assertions.assertThat((int)subtracted.getTaskHeapMemory().getMebiBytes()).isZero();
        Assertions.assertThat((Optional)subtracted.getExtendedResource(EXTERNAL_RESOURCE_NAME)).contains((Object)new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.6));
    }

    @Test
    void testSubtractOtherHasLargerResources() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)0.2, (int)200).build();
        Assertions.assertThatThrownBy(() -> rs1.subtract(rs2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSubtractThisUnknown() {
        ResourceSpec rs1 = ResourceSpec.UNKNOWN;
        ResourceSpec rs2 = ResourceSpec.newBuilder((double)0.2, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.5)).build();
        ResourceSpec subtracted = rs1.subtract(rs2);
        Assertions.assertThat((Object)subtracted).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testSubtractOtherUnknown() {
        ResourceSpec rs1 = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.1)).build();
        ResourceSpec rs2 = ResourceSpec.UNKNOWN;
        ResourceSpec subtracted = rs1.subtract(rs2);
        Assertions.assertThat((Object)subtracted).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }

    @Test
    void testZeroExtendedResourceFromConstructor() {
        ResourceSpec resourceSpec = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 0.0)).build();
        Assertions.assertThat((Map)resourceSpec.getExtendedResources()).isEmpty();
    }

    @Test
    void testZeroExtendedResourceFromSubtract() {
        ResourceSpec resourceSpec = ResourceSpec.newBuilder((double)1.0, (int)100).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        Assertions.assertThat((Map)resourceSpec.subtract(resourceSpec).getExtendedResources()).isEmpty();
    }
}

