/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarksWithIdleness;
import org.apache.flink.util.clock.ManualClock;
import org.apache.flink.util.clock.RelativeClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WatermarksWithIdlenessTest {
    WatermarksWithIdlenessTest() {
    }

    @Test
    void testZeroTimeout() {
        Assertions.assertThatThrownBy(() -> new WatermarksWithIdleness((WatermarkGenerator)new AscendingTimestampsWatermarks(), Duration.ZERO)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testNegativeTimeout() {
        Assertions.assertThatThrownBy(() -> new WatermarksWithIdleness((WatermarkGenerator)new AscendingTimestampsWatermarks(), Duration.ofMillis(-1L))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testInitiallyActive() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = new WatermarksWithIdleness.IdlenessTimer((RelativeClock)clock, Duration.ofMillis(10L));
        Assertions.assertThat((boolean)timer.checkIfIdle()).isFalse();
    }

    @Test
    void testIdleWithoutEvents() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = new WatermarksWithIdleness.IdlenessTimer((RelativeClock)clock, Duration.ofMillis(10L));
        timer.checkIfIdle();
        clock.advanceTime(11L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)timer.checkIfIdle()).isTrue();
    }

    @Test
    void testRepeatedIdleChecks() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = WatermarksWithIdlenessTest.createTimerAndMakeIdle(clock, Duration.ofMillis(122L));
        Assertions.assertThat((boolean)timer.checkIfIdle()).isTrue();
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)timer.checkIfIdle()).isTrue();
    }

    @Test
    void testActiveAfterIdleness() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = WatermarksWithIdlenessTest.createTimerAndMakeIdle(clock, Duration.ofMillis(10L));
        timer.activity();
        Assertions.assertThat((boolean)timer.checkIfIdle()).isFalse();
    }

    @Test
    void testIdleActiveIdle() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = WatermarksWithIdlenessTest.createTimerAndMakeIdle(clock, Duration.ofMillis(122L));
        timer.activity();
        Assertions.assertThat((boolean)timer.checkIfIdle()).isFalse();
        timer.checkIfIdle();
        clock.advanceTime(Duration.ofMillis(123L));
        Assertions.assertThat((boolean)timer.checkIfIdle()).isTrue();
    }

    private static WatermarksWithIdleness.IdlenessTimer createTimerAndMakeIdle(ManualClock clock, Duration idleTimeout) {
        WatermarksWithIdleness.IdlenessTimer timer = new WatermarksWithIdleness.IdlenessTimer((RelativeClock)clock, idleTimeout);
        timer.checkIfIdle();
        clock.advanceTime(Duration.ofMillis(idleTimeout.toMillis() + 1L));
        Assertions.assertThat((boolean)timer.checkIfIdle()).isTrue();
        return timer;
    }
}

