/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.flink.util.ClassLoaderUtil;
import org.apache.flink.util.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassLoaderUtilsTest {
    ClassLoaderUtilsTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testWithURLClassLoader() throws Exception {
        File validJar = File.createTempFile("flink-url-test", ".tmp");
        ClassLoaderUtilsTest.createValidJar(validJar);
        try (JarFile jarFile = null;){
            jarFile = new JarFile(validJar.getAbsolutePath());
        }
        File invalidJar = File.createTempFile("flink-url-test", ".tmp");
        try (FileOutputStream invalidout = new FileOutputStream(invalidJar);){
            invalidout.write(new byte[]{-1, 1, -2, 3, -3, 4});
        }
        File nonExisting = File.createTempFile("flink-url-test", ".tmp");
        Assertions.assertThat((boolean)nonExisting.delete()).isTrue();
        URL[] urls = new URL[]{new URL("http", "localhost", 26712, "/some/file/path"), new URL("file", null, validJar.getAbsolutePath()), new URL("file", null, invalidJar.getAbsolutePath()), new URL("file", null, nonExisting.getAbsolutePath())};
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        String info = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)loader);
        Assertions.assertThat((String)info).contains(new CharSequence[]{"/some/file/path"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{validJar.getAbsolutePath() + "' (valid"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{invalidJar.getAbsolutePath() + "' (invalid JAR"});
        Assertions.assertThat((String)info).contains(new CharSequence[]{nonExisting.getAbsolutePath() + "' (missing"});
        validJar.delete();
        invalidJar.delete();
    }

    private static void createValidJar(File jarFile) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(jarFile);
             JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest());){
            Class<ClassLoaderUtilsTest> classToIncludeInJar = ClassLoaderUtilsTest.class;
            ClassLoaderUtilsTest.startJarEntryForClass(classToIncludeInJar, jarOutputStream);
            ClassLoaderUtilsTest.copyClassFileToJar(classToIncludeInJar, jarOutputStream);
        }
    }

    private static void startJarEntryForClass(Class<?> clazz, JarOutputStream jarOutputStream) throws IOException {
        String jarEntryName = clazz.getName().replace('.', '/') + ".class";
        jarOutputStream.putNextEntry(new JarEntry(jarEntryName));
    }

    private static void copyClassFileToJar(Class<?> clazz, JarOutputStream jarOutputStream) throws IOException {
        try (InputStream classInputStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");){
            IOUtils.copyBytes((InputStream)classInputStream, (OutputStream)jarOutputStream, (int)128, (boolean)false);
        }
        jarOutputStream.closeEntry();
    }

    @Test
    void testWithAppClassLoader() {
        String result = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertThat((String)result.toLowerCase()).contains(new CharSequence[]{"system classloader"});
    }

    @Test
    void testInvalidClassLoaders() {
        Assertions.assertThat((String)ClassLoaderUtil.getUserCodeClassLoaderInfo(null)).isNotNull();
    }
}

