/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;

public class DeeplyEqualsChecker {
    private final List<Tuple2<BiFunction<Object, Object, Boolean>, CustomEqualityChecker>> customCheckers = new ArrayList<Tuple2<BiFunction<Object, Object, Boolean>, CustomEqualityChecker>>();

    public DeeplyEqualsChecker withCustomCheck(BiFunction<Object, Object, Boolean> shouldCheck, CustomEqualityChecker comparator) {
        this.customCheckers.add((Tuple2<BiFunction<Object, Object, Boolean>, CustomEqualityChecker>)Tuple2.of(shouldCheck, (Object)comparator));
        return this;
    }

    public boolean deepEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return this.customCheck(o1, o2).orElseGet(() -> this.deepEquals0(o1, o2));
    }

    private Optional<Boolean> customCheck(Object o1, Object o2) {
        return this.customCheckers.stream().filter(checker -> (Boolean)((BiFunction)checker.f0).apply(o1, o2)).findAny().map(checker -> ((CustomEqualityChecker)checker.f1).check(o1, o2, this));
    }

    private boolean deepEquals0(Object e1, Object e2) {
        if (e1.getClass().isArray() && e2.getClass().isArray()) {
            return this.deepEqualsArray(e1, e2);
        }
        if (e1 instanceof Tuple && e2 instanceof Tuple) {
            return this.deepEqualsTuple((Tuple)e1, (Tuple)e2);
        }
        if (e1 instanceof Throwable && e2 instanceof Throwable) {
            return ((Throwable)e1).getMessage().equals(((Throwable)e2).getMessage());
        }
        return e1.equals(e2);
    }

    private boolean deepEqualsTuple(Tuple tuple1, Tuple tuple2) {
        if (tuple1.getArity() != tuple2.getArity()) {
            return false;
        }
        for (int i = 0; i < tuple1.getArity(); ++i) {
            Object o2;
            Object o1 = tuple1.getField(i);
            if (this.deepEquals(o1, o2 = tuple2.getField(i))) continue;
            return false;
        }
        return true;
    }

    private boolean deepEqualsArray(Object array1, Object array2) {
        int length2;
        int length1 = Array.getLength(array1);
        if (length1 != (length2 = Array.getLength(array2))) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            Object o2;
            Object o1 = Array.get(array1, i);
            if (this.deepEquals(o1, o2 = Array.get(array2, i))) continue;
            return false;
        }
        return true;
    }

    public static interface CustomEqualityChecker {
        public boolean check(Object var1, Object var2, DeeplyEqualsChecker var3);
    }
}

