/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class MemorySegmentFactoryTest {
    MemorySegmentFactoryTest() {
    }

    @Test
    void testWrapCopyChangingData() {
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        byte[] changingData = new byte[data.length];
        System.arraycopy(data, 0, changingData, 0, data.length);
        MemorySegment segment = MemorySegmentFactory.wrapCopy((byte[])changingData, (int)0, (int)changingData.length);
        changingData[0] = (byte)(changingData[0] + 1);
        Assertions.assertThat((byte[])segment.getHeapMemory()).containsExactly(data);
    }

    @Test
    void testWrapPartialCopy() {
        byte[] data = new byte[]{1, 2, 3, 5, 6};
        MemorySegment segment = MemorySegmentFactory.wrapCopy((byte[])data, (int)0, (int)(data.length / 2));
        byte[] exp = new byte[segment.size()];
        System.arraycopy(data, 0, exp, 0, exp.length);
        Assertions.assertThat((byte[])segment.getHeapMemory()).containsExactly(exp);
    }

    @Test
    void testWrapCopyEmpty() {
        MemorySegmentFactory.wrapCopy((byte[])new byte[0], (int)0, (int)0);
    }

    @Test
    void testWrapCopyWrongStart() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> MemorySegmentFactory.wrapCopy((byte[])new byte[]{1, 2, 3}, (int)10, (int)3));
    }

    @Test
    void testWrapCopyWrongEnd() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> MemorySegmentFactory.wrapCopy((byte[])new byte[]{1, 2, 3}, (int)0, (int)10));
    }
}

