/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class MemorySegmentChecksTest {
    MemorySegmentChecksTest() {
    }

    @Test
    void testHeapNullBuffer2() {
        AssertionsForClassTypes.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> new MemorySegment((byte[])null, new Object()));
    }

    @Test
    void testOffHeapNullBuffer2() {
        AssertionsForClassTypes.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> new MemorySegment((ByteBuffer)null, new Object()));
    }

    @Test
    void testNonDirectBuffer() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new MemorySegment(ByteBuffer.allocate(1024), new Object()));
    }
}

