/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ByteArrayOutputStreamWithPosTest {
    private static final int BUFFER_SIZE = 32;
    private ByteArrayOutputStreamWithPos stream;

    ByteArrayOutputStreamWithPosTest() {
    }

    @BeforeEach
    void setup() {
        this.stream = new ByteArrayOutputStreamWithPos(32);
    }

    @Test
    void testSetPositionWhenBufferIsFull() throws Exception {
        this.stream.write(new byte[32]);
        Assertions.assertThat((byte[])this.stream.getBuf()).hasSize(32);
        Assertions.assertThat((int)this.stream.getPosition()).isEqualTo(32);
        this.stream.setPosition(32);
        Assertions.assertThat((int)this.stream.getPosition()).isEqualTo(32);
    }

    @Test
    void testSetNegativePosition() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            this.stream.write(new byte[32]);
            this.stream.setPosition(-1);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Position out of bounds");
    }

    @Test
    void testSetPositionLargerThanBufferSize() throws Exception {
        this.stream.write(new byte[32]);
        Assertions.assertThat((byte[])this.stream.getBuf()).hasSize(32);
        this.stream.setPosition(33);
        Assertions.assertThat((byte[])this.stream.getBuf()).hasSize(64);
        Assertions.assertThat((int)this.stream.getPosition()).isEqualTo(33);
    }

    @Test
    void testToString() throws IOException {
        byte[] data = "1234567890".getBytes(ConfigConstants.DEFAULT_CHARSET);
        try (ByteArrayOutputStreamWithPos stream = new ByteArrayOutputStreamWithPos(data.length);){
            stream.write(data);
            Assertions.assertThat((byte[])stream.toString().getBytes(ConfigConstants.DEFAULT_CHARSET)).containsExactly(data);
            for (int i = 0; i < data.length; ++i) {
                stream.setPosition(i);
                Assertions.assertThat((byte[])stream.toString().getBytes(ConfigConstants.DEFAULT_CHARSET)).containsExactly(Arrays.copyOf(data, i));
            }
            stream.setPosition(data.length + 1);
            Assertions.assertThat((byte[])stream.toString().getBytes(ConfigConstants.DEFAULT_CHARSET)).containsExactly(Arrays.copyOf(data, data.length + 1));
        }
    }
}

