/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultSplitAssignerTest {
    DefaultSplitAssignerTest() {
    }

    @Test
    void testSerialSplitAssignment() {
        int NUM_SPLITS = 50;
        HashSet<GenericInputSplit> splits = new HashSet<GenericInputSplit>();
        for (int i = 0; i < 50; ++i) {
            splits.add(new GenericInputSplit(i, 50));
        }
        DefaultInputSplitAssigner ia = new DefaultInputSplitAssigner(splits);
        InputSplit is = null;
        while ((is = ia.getNextInputSplit("", 0)) != null) {
            Assertions.assertThat((boolean)splits.remove(is)).isTrue();
        }
        Assertions.assertThat(splits).isEmpty();
        Assertions.assertThat((Object)ia.getNextInputSplit("", 0)).isNull();
    }

    @Test
    void testConcurrentSplitAssignment() throws InterruptedException {
        int i;
        int NUM_THREADS = 10;
        int NUM_SPLITS = 500;
        int SUM_OF_IDS = 124750;
        HashSet<GenericInputSplit> splits = new HashSet<GenericInputSplit>();
        for (int i2 = 0; i2 < 500; ++i2) {
            splits.add(new GenericInputSplit(i2, 500));
        }
        DefaultInputSplitAssigner ia = new DefaultInputSplitAssigner(splits);
        AtomicInteger splitsRetrieved = new AtomicInteger(0);
        AtomicInteger sumOfIds = new AtomicInteger(0);
        Runnable retriever = () -> {
            GenericInputSplit split;
            String host = "";
            while ((split = (GenericInputSplit)ia.getNextInputSplit(host, 0)) != null) {
                splitsRetrieved.incrementAndGet();
                sumOfIds.addAndGet(split.getSplitNumber());
            }
        };
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread(retriever);
            threads[i].setDaemon(true);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join(5000L);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((boolean)threads[i].isAlive()).isFalse();
        }
        Assertions.assertThat((AtomicInteger)splitsRetrieved).hasValue(500);
        Assertions.assertThat((AtomicInteger)sumOfIds).hasValue(124750);
        Assertions.assertThat((Object)ia.getNextInputSplit("", 0)).isNull();
    }
}

