/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.local.AbstractRecoverableFsDataOutputStreamTest;
import org.apache.flink.core.fs.local.LocalRecoverableFsDataOutputStream;

public class LocalRecoverableFsDataOutputStreamTest
extends AbstractRecoverableFsDataOutputStreamTest {
    @Override
    public Tuple2<RecoverableFsDataOutputStream, Closeable> createTestInstance(Path target, Path temp, List<AbstractRecoverableFsDataOutputStreamTest.Event> testLog) throws IOException {
        TestFileChannel fileChannel = new TestFileChannel(FileChannel.open(temp, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW), testLog);
        TestOutputStream fos = new TestOutputStream(new BufferedOutputStream(Channels.newOutputStream(fileChannel)), testLog);
        LocalRecoverableFsDataOutputStream testOutStreamInstance = new LocalRecoverableFsDataOutputStream(target.toFile(), temp.toFile(), (FileChannel)fileChannel, (OutputStream)fos);
        return new Tuple2((Object)testOutStreamInstance, fos::actualClose);
    }

    static class TestFileChannel
    extends FileChannel {
        final FileChannel delegate;
        private final List<AbstractRecoverableFsDataOutputStreamTest.Event> events;

        TestFileChannel(FileChannel delegate, List<AbstractRecoverableFsDataOutputStreamTest.Event> events) {
            this.delegate = delegate;
            this.events = events;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        @Override
        public long position() throws IOException {
            return this.delegate.position();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            return this.delegate.position(newPosition);
        }

        @Override
        public long size() throws IOException {
            return this.delegate.size();
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            return this.delegate.truncate(size);
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.delegate.force(metaData);
            this.events.add(AbstractRecoverableFsDataOutputStreamTest.Event.SYNC);
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            return this.delegate.transferTo(position, count, target);
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            return this.delegate.transferFrom(src, position, count);
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.delegate.read(dst, position);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.delegate.write(src, position);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.delegate.map(mode, position, size);
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return this.delegate.lock(position, size, shared);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.delegate.tryLock(position, size, shared);
        }

        @Override
        protected void implCloseChannel() {
        }
    }

    private static class TestOutputStream
    extends FilterOutputStream {
        private final List<AbstractRecoverableFsDataOutputStreamTest.Event> events;

        public TestOutputStream(OutputStream out, List<AbstractRecoverableFsDataOutputStreamTest.Event> events) {
            super(out);
            this.events = events;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.events.add(AbstractRecoverableFsDataOutputStreamTest.Event.FLUSH);
        }

        @Override
        public void close() {
            this.events.add(AbstractRecoverableFsDataOutputStreamTest.Event.CLOSE);
        }

        public void actualClose() throws IOException {
            super.close();
        }
    }
}

