/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;

public class FileSystemTestUtils {
    public static void checkPathEventualExistence(FileSystem fs, Path path, boolean expectedExists, long consistencyToleranceNS) throws IOException, InterruptedException {
        boolean dirExists;
        long deadline = System.nanoTime() + consistencyToleranceNS;
        while ((dirExists = fs.exists(path)) != expectedExists && System.nanoTime() - deadline < 0L) {
            Thread.sleep(10L);
        }
        Assertions.assertThat((boolean)dirExists).isEqualTo(expectedExists);
    }
}

