/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class UnmodifiableConfigurationTest {
    UnmodifiableConfigurationTest() {
    }

    @Test
    void testOverrideAddMethods() {
        Class<UnmodifiableConfiguration> clazz = UnmodifiableConfiguration.class;
        for (Method m : clazz.getMethods()) {
            if (!m.getName().startsWith("add")) continue;
            Assertions.assertThat(m.getDeclaringClass()).isEqualTo(clazz);
        }
    }

    @Test
    void testExceptionOnSet() {
        ConfigOption rawOption = ConfigOptions.key((String)"testkey").defaultValue((Object)"value");
        HashMap<Class<Object>, Object> parameters = new HashMap<Class<Object>, Object>();
        parameters.put(byte[].class, new byte[0]);
        parameters.put(Class.class, Object.class);
        parameters.put(Integer.TYPE, 0);
        parameters.put(Long.TYPE, 0L);
        parameters.put(Float.TYPE, Float.valueOf(0.0f));
        parameters.put(Double.TYPE, 0.0);
        parameters.put(String.class, "");
        parameters.put(Boolean.TYPE, false);
        Class<UnmodifiableConfiguration> clazz = UnmodifiableConfiguration.class;
        UnmodifiableConfiguration config = new UnmodifiableConfiguration(new Configuration());
        for (Method m : clazz.getMethods()) {
            if (!m.getName().startsWith("set") || m.getName().equals("set")) continue;
            Class<?> keyClass = m.getParameterTypes()[0];
            Class<?> parameterClass = m.getParameterTypes()[1];
            String key = keyClass == String.class ? "key" : rawOption;
            Object parameter = parameters.get(parameterClass);
            ((ObjectAssert)Assertions.assertThat(parameter).as("method " + m + " not covered by test", new Object[0])).isNotNull();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> m.invoke((Object)config, key, parameter)).isInstanceOf(InvocationTargetException.class)).hasCauseInstanceOf(UnsupportedOperationException.class);
        }
    }
}

