/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.AbstractGenericTypeSerializerTest;
import org.apache.flink.api.java.typeutils.runtime.TestDataOutputSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KryoGenericTypeSerializerTest
extends AbstractGenericTypeSerializerTest {
    SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();

    KryoGenericTypeSerializerTest() {
    }

    @Test
    void testJavaList() {
        ArrayList<Integer> a = new ArrayList<Integer>();
        this.fillCollection(a);
        this.runTests(a);
    }

    @Test
    void testJavaSet() {
        HashSet<Integer> b = new HashSet<Integer>();
        this.fillCollection(b);
        this.runTests(b);
    }

    @Test
    void testJavaDequeue() {
        LinkedList<Integer> c = new LinkedList<Integer>();
        this.fillCollection(c);
        this.runTests(c);
    }

    private void fillCollection(Collection<Integer> coll) {
        coll.add(42);
        coll.add(1337);
        coll.add(49);
        coll.add(1);
    }

    @Override
    protected <T> TypeSerializer<T> createSerializer(Class<T> type) {
        return new KryoSerializer(type, (SerializerConfig)this.serializerConfigImpl);
    }

    @Test
    void testForwardEOFExceptionWhileSerializing() {
        char[] charData = new char[40000];
        Random rnd = new Random();
        for (int i = 0; i < charData.length; ++i) {
            charData[i] = (char)rnd.nextInt(10000);
        }
        String str = new String(charData);
        TestDataOutputSerializer target = new TestDataOutputSerializer(10000, 30000);
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        Assertions.assertThatThrownBy(() -> serializer.serialize((Object)str, (DataOutputView)target)).isInstanceOf(EOFException.class);
    }

    @Test
    void testForwardEOFExceptionWhileDeserializing() throws IOException {
        int numElements = 100;
        TestDataOutputSerializer target = new TestDataOutputSerializer(5 * numElements, 5 * numElements);
        KryoSerializer serializer = new KryoSerializer(Integer.class, (SerializerConfig)new SerializerConfigImpl());
        for (int i = 0; i < numElements; ++i) {
            serializer.serialize((Object)i, (DataOutputView)target);
        }
        ComparatorTestBase.TestInputView source = new ComparatorTestBase.TestInputView(target.copyByteBuffer());
        for (int i = 0; i < numElements; ++i) {
            int value = (Integer)serializer.deserialize((DataInputView)source);
            Assertions.assertThat((int)value).isEqualTo(i);
        }
        Assertions.assertThatThrownBy(() -> {
            Integer cfr_ignored_0 = (Integer)serializer.deserialize((DataInputView)source);
        }).isInstanceOf(EOFException.class);
    }

    @Test
    void validateReferenceMappingEnabled() {
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        Kryo kryo = serializer.getKryo();
        Assertions.assertThat((boolean)kryo.getReferences()).isTrue();
    }
}

