/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractionException;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LambdaExtractionTest {
    private static final TypeInformation<Tuple2<Tuple1<Integer>, Boolean>> NESTED_TUPLE_BOOLEAN_TYPE = new TypeHint<Tuple2<Tuple1<Integer>, Boolean>>(){}.getTypeInfo();
    private static final TypeInformation<Tuple2<Tuple1<Integer>, Double>> NESTED_TUPLE_DOUBLE_TYPE = new TypeHint<Tuple2<Tuple1<Integer>, Double>>(){}.getTypeInfo();
    private static final MapFunction<String, Integer> STATIC_LAMBDA = Integer::parseInt;

    LambdaExtractionTest() {
    }

    @Test
    void testIdentifyLambdas() throws TypeExtractionException {
        MapFunction<String, Integer> anonymousFromInterface = new MapFunction<String, Integer>(){

            public Integer map(String value) {
                return Integer.parseInt(value);
            }
        };
        RichMapFunction<String, Integer> anonymousFromClass = new RichMapFunction<String, Integer>(){

            public Integer map(String value) {
                return Integer.parseInt(value);
            }
        };
        StaticMapper fromProperClass = new StaticMapper();
        ToTuple<Integer> fromDerived = new ToTuple<Integer>(){

            @Override
            public Tuple2<Integer, Long> map(Integer value) {
                return new Tuple2((Object)value, (Object)1L);
            }
        };
        MapFunction & Serializable staticLambda = Integer::parseInt;
        MapFunction & Serializable instanceLambda = Object::toString;
        MapFunction & Serializable constructorLambda = Integer::new;
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)anonymousFromInterface)).isNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)anonymousFromClass)).isNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)fromProperClass)).isNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)fromDerived)).isNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)staticLambda)).isNotNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)instanceLambda)).isNotNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda((Function)constructorLambda)).isNotNull();
        Assertions.assertThat((Object)TypeExtractionUtils.checkAndExtractLambda(STATIC_LAMBDA)).isNotNull();
    }

    @Test
    void testLambdaWithMemberVariable() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new MyClass().getMapFunction(), (TypeInformation)Types.INT);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testLambdaWithLocalVariable() {
        String s = "mystring";
        int k = 24;
        int j = 26;
        MapFunction & Serializable f = (MapFunction & Serializable)i -> s + 24 + j;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)Types.INT);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testLambdaWithNonGenericResultType() {
        MapFunction & Serializable f = (MapFunction & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(BasicTypeInfo.class);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testMapLambda() {
        MapFunction & Serializable f = (MapFunction & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType()).isTrue();
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testFlatMapLambda() {
        FlatMapFunction & Serializable f = (FlatMapFunction & Serializable)(i, out) -> out.collect(null);
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes((FlatMapFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType()).isTrue();
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testMapPartitionLambda() {
        MapPartitionFunction & Serializable f = (MapPartitionFunction & Serializable)(i, o) -> {};
        TypeInformation ti = TypeExtractor.getMapPartitionReturnTypes((MapPartitionFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType()).isTrue();
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testJoinLambda() {
        JoinFunction & Serializable f = (JoinFunction & Serializable)(i1, i2) -> null;
        TypeInformation ti = TypeExtractor.getJoinReturnTypes((JoinFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, NESTED_TUPLE_DOUBLE_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType()).isTrue();
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testCoGroupLambda() {
        CoGroupFunction & Serializable f = (CoGroupFunction & Serializable)(i1, i2, o) -> {};
        TypeInformation ti = TypeExtractor.getCoGroupReturnTypes((CoGroupFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, NESTED_TUPLE_DOUBLE_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType()).isTrue();
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testKeySelectorLambda() {
        KeySelector & Serializable f = (KeySelector & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getKeySelectorTypes((KeySelector)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType()).isTrue();
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testLambdaTypeErasure() {
        MapFunction & Serializable f = (MapFunction & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)new TypeHint<Tuple1<Integer>>(){}.getTypeInfo(), null, (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
    }

    @Test
    void testLambdaWithoutTypeErasure() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(Tuple1::of, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, (boolean)true);
        Assertions.assertThat((Object)ti).isInstanceOf(MissingTypeInfo.class);
    }

    @Test
    void testPartitionerLambda() {
        Partitioner & Serializable partitioner = (Partitioner & Serializable)(key, numPartitions) -> ((String)key.f1).length() % numPartitions;
        TypeInformation ti = TypeExtractor.getPartitionerTypes((Partitioner)partitioner, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assertions.assertThat((boolean)ti.isTupleType()).isTrue();
            Assertions.assertThat((int)ti.getArity()).isEqualTo(2);
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
            Assertions.assertThat((Object)((TupleTypeInfo)ti).getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    void testInstanceMethodRefSameType() {
        MapFunction & Serializable f = MyType::getKey;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)TypeExtractor.createTypeInfo(MyType.class));
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testInstanceMethodRefSuperType() {
        MapFunction & Serializable f = Object::toString;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testInstanceMethodRefSuperTypeProtected() {
        MapFunction & Serializable f = MyType::getKey2;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)TypeExtractor.createTypeInfo(MySubtype.class));
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testConstructorMethodRef() {
        MapFunction & Serializable f = Integer::new;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testSamMethodExtractionInterfaceWithDefaultMethod() {
        Method sam = TypeExtractionUtils.getSingleAbstractMethod(InterfaceWithDefaultMethod.class);
        Assertions.assertThat((Object)sam).isNotNull();
        Assertions.assertThat((String)sam.getName()).isEqualTo("samMethod");
    }

    @Test
    void getSingleAbstractMethodMultipleMethods() {
        Assertions.assertThatThrownBy(() -> TypeExtractionUtils.getSingleAbstractMethod(InterfaceWithMultipleMethods.class)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testSingleAbstractMethodNoAbstractMethods() {
        Assertions.assertThatThrownBy(() -> TypeExtractionUtils.getSingleAbstractMethod(InterfaceWithoutAbstractMethod.class)).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testSingleAbstractMethodNotAnInterface() {
        Assertions.assertThatThrownBy(() -> TypeExtractionUtils.getSingleAbstractMethod(AbstractClassWithSingleAbstractMethod.class)).isInstanceOf(InvalidTypesException.class);
    }

    private abstract class AbstractClassWithSingleAbstractMethod {
        private AbstractClassWithSingleAbstractMethod() {
        }

        public abstract void defaultMethod();
    }

    private static interface InterfaceWithoutAbstractMethod {
        default public void defaultMethod() {
        }
    }

    private static interface InterfaceWithMultipleMethods {
        public void firstMethod();

        public void secondMethod();
    }

    private static interface InterfaceWithDefaultMethod {
        public void samMethod();

        default public void defaultMethod() {
        }
    }

    private static class MySubtype
    extends MyType {
        public boolean test;

        private MySubtype() {
        }
    }

    private static class MyType {
        private int key;

        private MyType() {
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        protected int getKey2() {
            return 0;
        }
    }

    private static class MyClass {
        private final String s = "mystring";

        private MyClass() {
        }

        public MapFunction<Integer, String> getMapFunction() {
            return (MapFunction & Serializable)i -> "mystring";
        }
    }

    private static interface ToTuple<T>
    extends MapFunction<T, Tuple2<T, Long>> {
        public Tuple2<T, Long> map(T var1) throws Exception;
    }

    private static class StaticMapper
    implements MapFunction<String, Integer> {
        private StaticMapper() {
        }

        public Integer map(String value) {
            return Integer.parseInt(value);
        }
    }
}

