/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.StringArraySerializer;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringArraySerializerTest
extends SerializerTestBase<String[]> {
    StringArraySerializerTest() {
    }

    @Override
    protected TypeSerializer<String[]> createSerializer() {
        return new StringArraySerializer();
    }

    @Override
    protected Class<String[]> getTypeClass() {
        return String[].class;
    }

    @Override
    protected int getLength() {
        return -1;
    }

    protected String[][] getTestData() {
        Random rnd = new Random(874597969123412341L);
        return new String[][]{{"a", "", "bcd", "jbmbmner8 jhk hj \n \t \u00fc\u00e4\u00df\u00df@\u00b5", "", "non-empty"}, {"a", null, "", null, "bcd", null, "jbmbmner8 jhk hj \n \t \u00fc\u00e4\u00df\u00df@\u00b5", null, "", null, "non-empty"}, {StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000)}, {StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), null, StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), null, "", StringUtils.getRandomString((Random)rnd, (int)10000, (int)0x200000), "", null}};
    }

    @Test
    void arrayTypeIsMutable() {
        StringArraySerializer serializer = (StringArraySerializer)this.createSerializer();
        Assertions.assertThat((boolean)serializer.isImmutableType()).isFalse();
    }
}

