/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ListStateDescriptorTest {
    ListStateDescriptorTest() {
    }

    @Test
    void testListStateDescriptor() throws Exception {
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        ListStateDescriptor descr = new ListStateDescriptor("testName", (TypeSerializer)serializer);
        Assertions.assertThat((String)descr.getName()).isEqualTo("testName");
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isInstanceOf(ListSerializer.class);
        Assertions.assertThat((Object)descr.getElementSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getElementSerializer()).isEqualTo((Object)serializer);
        ListStateDescriptor copy = (ListStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assertions.assertThat((String)copy.getName()).isEqualTo("testName");
        Assertions.assertThat((Object)copy.getSerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getSerializer()).isInstanceOf(ListSerializer.class);
        Assertions.assertThat((Object)copy.getElementSerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getElementSerializer()).isEqualTo((Object)serializer);
    }

    @Test
    void testHashCodeEquals() throws Exception {
        String name = "testName";
        ListStateDescriptor original = new ListStateDescriptor("testName", String.class);
        ListStateDescriptor same = new ListStateDescriptor("testName", String.class);
        ListStateDescriptor sameBySerializer = new ListStateDescriptor("testName", (TypeSerializer)StringSerializer.INSTANCE);
        Assertions.assertThat((Object)same).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)sameBySerializer).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
        Assertions.assertThat((Object)sameBySerializer).isEqualTo((Object)original);
        ListStateDescriptor clone = (ListStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
    }

    @Test
    void testSerializerDuplication() {
        KryoSerializer statefulSerializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        ListStateDescriptor descr = new ListStateDescriptor("foobar", (TypeSerializer)statefulSerializer);
        TypeSerializer serializerA = descr.getElementSerializer();
        TypeSerializer serializerB = descr.getElementSerializer();
        Assertions.assertThat((Object)serializerB).isNotSameAs((Object)serializerA);
        TypeSerializer listSerializerA = descr.getSerializer();
        TypeSerializer listSerializerB = descr.getSerializer();
        Assertions.assertThat((Object)listSerializerB).isNotSameAs((Object)listSerializerA);
    }
}

