/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.TestingWatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AscendingTimestampsWatermarksTest {
    AscendingTimestampsWatermarksTest() {
    }

    @Test
    void testWatermarkBeforeRecords() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        AscendingTimestampsWatermarks watermarks = new AscendingTimestampsWatermarks();
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(Long.MIN_VALUE);
    }

    @Test
    void testWatermarkAfterEvent() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        AscendingTimestampsWatermarks watermarks = new AscendingTimestampsWatermarks();
        watermarks.onEvent(new Object(), 1337L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(1336L);
    }

    @Test
    void testWatermarkAfterEventWithLowerTimestamp() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        AscendingTimestampsWatermarks watermarks = new AscendingTimestampsWatermarks();
        watermarks.onEvent(new Object(), 12345L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12340L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(12344L);
    }
}

