/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecutionConfigTest {
    @Test
    void testDoubleTypeRegistration() {
        ExecutionConfig config = new ExecutionConfig();
        List<Class> types = Arrays.asList(Double.class, Integer.class, Double.class);
        List<Class> expectedTypes = Arrays.asList(Double.class, Integer.class);
        for (Class tpe : types) {
            config.getSerializerConfig().registerKryoType(tpe);
        }
        int counter = 0;
        for (Class tpe : config.getRegisteredKryoTypes()) {
            Assertions.assertThat((Class)tpe).isEqualTo((Object)expectedTypes.get(counter++));
        }
        Assertions.assertThat(expectedTypes).hasSize(counter);
    }

    @Test
    void testConfigurationOfParallelism() {
        ExecutionConfig config = new ExecutionConfig();
        int parallelism = 36;
        config.setParallelism(parallelism);
        Assertions.assertThat((int)parallelism).isEqualTo(config.getParallelism());
        parallelism = -1;
        config.setParallelism(parallelism);
        Assertions.assertThat((int)parallelism).isEqualTo(config.getParallelism());
    }

    @Test
    void testDisableGenericTypes() {
        SerializerConfigImpl conf = new SerializerConfigImpl();
        GenericTypeInfo typeInfo = new GenericTypeInfo(Object.class);
        TypeSerializer serializer = typeInfo.createSerializer((SerializerConfig)conf);
        Assertions.assertThat((Object)serializer).isInstanceOf(KryoSerializer.class);
        conf.setGenericTypes(false);
        Assertions.assertThatThrownBy(() -> ExecutionConfigTest.lambda$testDisableGenericTypes$0((TypeInformation)typeInfo, conf), (String)"should have failed with an exception", (Object[])new Object[0]).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testExecutionConfigSerialization() throws Exception {
        Random r = new Random();
        int parallelism = 1 + r.nextInt(10);
        boolean closureCleanerEnabled = r.nextBoolean();
        boolean forceAvroEnabled = r.nextBoolean();
        boolean forceKryoEnabled = r.nextBoolean();
        boolean disableGenericTypes = r.nextBoolean();
        boolean objectReuseEnabled = r.nextBoolean();
        ExecutionConfig config = new ExecutionConfig();
        if (closureCleanerEnabled) {
            config.enableClosureCleaner();
        } else {
            config.disableClosureCleaner();
        }
        config.getSerializerConfig().setForceAvro(forceAvroEnabled);
        config.getSerializerConfig().setForceKryo(forceKryoEnabled);
        config.getSerializerConfig().setGenericTypes(!disableGenericTypes);
        if (objectReuseEnabled) {
            config.enableObjectReuse();
        } else {
            config.disableObjectReuse();
        }
        config.setParallelism(parallelism);
        ExecutionConfig copy1 = (ExecutionConfig)CommonTestUtils.createCopySerializable((Serializable)config);
        ExecutionConfig copy2 = (ExecutionConfig)new SerializedValue((Object)config).deserializeValue(this.getClass().getClassLoader());
        Assertions.assertThat((Object)copy1).isNotNull();
        Assertions.assertThat((Object)copy2).isNotNull();
        Assertions.assertThat((Object)config).isEqualTo((Object)copy1);
        Assertions.assertThat((Object)config).isEqualTo((Object)copy2);
        Assertions.assertThat((boolean)closureCleanerEnabled).isEqualTo(copy1.isClosureCleanerEnabled());
        Assertions.assertThat((boolean)forceAvroEnabled).isEqualTo(copy1.getSerializerConfig().isForceAvroEnabled());
        Assertions.assertThat((boolean)forceKryoEnabled).isEqualTo(copy1.getSerializerConfig().isForceKryoEnabled());
        Assertions.assertThat((boolean)disableGenericTypes).isEqualTo(copy1.getSerializerConfig().hasGenericTypesDisabled());
        Assertions.assertThat((boolean)objectReuseEnabled).isEqualTo(copy1.isObjectReuseEnabled());
        Assertions.assertThat((int)parallelism).isEqualTo(copy1.getParallelism());
    }

    @Test
    void testGlobalParametersNotNull() {
        ExecutionConfig config = new ExecutionConfig();
        Assertions.assertThat((Object)config.getGlobalJobParameters()).isNotNull();
    }

    @Test
    void testGlobalParametersHashCode() {
        ExecutionConfig config = new ExecutionConfig();
        ExecutionConfig anotherConfig = new ExecutionConfig();
        Assertions.assertThat((int)config.getGlobalJobParameters().hashCode()).isEqualTo(anotherConfig.getGlobalJobParameters().hashCode());
    }

    @Test
    void testReadingDefaultConfig() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        Configuration configuration = new Configuration();
        executionConfig.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        Assertions.assertThat((Object)executionConfig).isEqualTo((Object)new ExecutionConfig());
    }

    @Test
    void testLoadingRegisteredKryoTypesFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.getSerializerConfig().registerKryoType(ExecutionConfigTest.class);
        configFromSetters.getSerializerConfig().registerKryoType(TestSerializer1.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-kryo-types", "org.apache.flink.api.common.ExecutionConfigTest;org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Collection)configFromConfiguration.getRegisteredKryoTypes()).isEqualTo((Object)configFromSetters.getRegisteredKryoTypes());
    }

    @Test
    void testLoadingRegisteredPojoTypesFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.registerPojoType(ExecutionConfigTest.class);
        configFromSetters.registerPojoType(TestSerializer1.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-pojo-types", "org.apache.flink.api.common.ExecutionConfigTest;org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Collection)configFromConfiguration.getRegisteredPojoTypes()).isEqualTo((Object)configFromSetters.getRegisteredPojoTypes());
    }

    @Test
    void testLoadingDefaultKryoSerializersFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.getSerializerConfig().addDefaultKryoSerializer(ExecutionConfigTest.class, TestSerializer1.class);
        configFromSetters.getSerializerConfig().addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.default-kryo-serializers", "class:org.apache.flink.api.common.ExecutionConfigTest,serializer:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1;class:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1,serializer:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer2");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Map)configFromConfiguration.getSerializerConfig().getDefaultKryoSerializers()).isEqualTo((Object)configFromSetters.getSerializerConfig().getDefaultKryoSerializers());
    }

    @Test
    void testLoadingSchedulerTypeFromConfiguration() {
        this.testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType.AdaptiveBatch);
        this.testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType.Default);
        this.testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType.Adaptive);
    }

    private void testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType schedulerType) {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)schedulerType);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Optional)configFromConfiguration.getSchedulerType()).hasValue((Object)schedulerType);
    }

    @Test
    void testNotOverridingRegisteredKryoTypesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.getSerializerConfig().registerKryoType(ExecutionConfigTest.class);
        config.getSerializerConfig().registerKryoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(ExecutionConfigTest.class);
        set.add(TestSerializer1.class);
        Assertions.assertThat((Collection)config.getRegisteredKryoTypes()).isEqualTo(set);
    }

    @Test
    void testNotOverridingRegisteredPojoTypesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.registerPojoType(ExecutionConfigTest.class);
        config.registerPojoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(ExecutionConfigTest.class);
        set.add(TestSerializer1.class);
        Assertions.assertThat((Collection)config.getRegisteredPojoTypes()).isEqualTo(set);
    }

    @Test
    void testNotOverridingRestartStrategiesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration = RestartStrategies.fixedDelayRestart((int)10, (Time)Time.minutes((long)2L));
        config.setRestartStrategy(restartStrategyConfiguration);
        config.configure((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)config.getRestartStrategy()).isEqualTo((Object)restartStrategyConfiguration);
    }

    @Test
    void testNotOverridingDefaultKryoSerializersFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.getSerializerConfig().addDefaultKryoSerializer(ExecutionConfigTest.class, TestSerializer1.class);
        config.getSerializerConfig().addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashMap<Class, Class> serialiers = new LinkedHashMap<Class, Class>();
        serialiers.put(ExecutionConfigTest.class, TestSerializer1.class);
        serialiers.put(TestSerializer1.class, TestSerializer2.class);
        Assertions.assertThat((Map)config.getSerializerConfig().getDefaultKryoSerializerClasses()).isEqualTo(serialiers);
    }

    private static /* synthetic */ void lambda$testDisableGenericTypes$0(TypeInformation typeInfo, SerializerConfigImpl conf) throws Throwable {
        typeInfo.createSerializer((SerializerConfig)conf);
    }

    private static class TestSerializer2
    extends Serializer<TestSerializer1>
    implements Serializable {
        private TestSerializer2() {
        }

        public void write(Kryo kryo, Output output, TestSerializer1 object) {
        }

        public TestSerializer1 read(Kryo kryo, Input input, Class<TestSerializer1> type) {
            return null;
        }
    }

    private static class TestSerializer1
    extends Serializer<ExecutionConfigTest>
    implements Serializable {
        private TestSerializer1() {
        }

        public void write(Kryo kryo, Output output, ExecutionConfigTest object) {
        }

        public ExecutionConfigTest read(Kryo kryo, Input input, Class<ExecutionConfigTest> type) {
            return null;
        }
    }
}

