/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.ExecutionConfigTest;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class ExecutionConfigFromConfigurationTest {
    @Parameter
    private TestSpec spec;

    ExecutionConfigFromConfigurationTest() {
    }

    @Parameters(name="{0}")
    private static Collection<TestSpec> specs() {
        return Arrays.asList(TestSpec.testValue(false).whenSetFromFile("pipeline.auto-generate-uids", "false").viaSetter(ExecutionConfigFromConfigurationTest.booleanSetter(ExecutionConfig::enableAutoGeneratedUIDs, ExecutionConfig::disableAutoGeneratedUIDs)).getterVia(ExecutionConfig::hasAutoGeneratedUIDsEnabled).nonDefaultValue(false), TestSpec.testValue(false).whenSetFromFile("pipeline.auto-type-registration", "false").viaSetter(ExecutionConfigFromConfigurationTest.booleanSetter(e -> {
            throw new IllegalArgumentException("Cannot enable auto type registration");
        }, ExecutionConfig::disableAutoTypeRegistration)).getterVia(e -> !e.isAutoTypeRegistrationDisabled()).nonDefaultValue(false), TestSpec.testValue(120000L).whenSetFromFile("pipeline.auto-watermark-interval", "2 min").viaSetter(ExecutionConfig::setAutoWatermarkInterval).getterVia(ExecutionConfig::getAutoWatermarkInterval).nonDefaultValue(123L), TestSpec.testValue(ExecutionConfig.ClosureCleanerLevel.TOP_LEVEL).whenSetFromFile("pipeline.closure-cleaner-level", "TOP_LEVEL").viaSetter(ExecutionConfig::setClosureCleanerLevel).getterVia(ExecutionConfig::getClosureCleanerLevel).nonDefaultValue(ExecutionConfig.ClosureCleanerLevel.NONE), TestSpec.testValue(true).whenSetFromFile("pipeline.force-avro", "true").viaSetter(ExecutionConfigFromConfigurationTest.booleanSetter(ec -> ec.getSerializerConfig().setForceAvro(true), ec -> ec.getSerializerConfig().setForceAvro(false))).getterVia(ec -> ec.getSerializerConfig().isForceAvroEnabled()).nonDefaultValue(true), TestSpec.testValue(false).whenSetFromFile("pipeline.force-kryo", "false").viaSetter(ExecutionConfigFromConfigurationTest.booleanSetter(ec -> ec.getSerializerConfig().setForceKryo(true), ec -> ec.getSerializerConfig().setForceKryo(false))).getterVia(ec -> ec.getSerializerConfig().isForceKryoEnabled()).nonDefaultValue(false), TestSpec.testValue(false).whenSetFromFile("pipeline.generic-types", "false").viaSetter(ExecutionConfigFromConfigurationTest.booleanSetter(ec -> ec.getSerializerConfig().setGenericTypes(true), ec -> ec.getSerializerConfig().setGenericTypes(false))).getterVia(execConfig -> !execConfig.getSerializerConfig().hasGenericTypesDisabled()).nonDefaultValue(false), TestSpec.testValue(ExecutionConfigFromConfigurationTest.getTestGlobalJobParameters()).whenSetFromFile("pipeline.global-job-parameters", "key1:value1,key2:value2").viaSetter(ExecutionConfig::setGlobalJobParameters).getterVia(ExecutionConfig::getGlobalJobParameters).nonDefaultValue(ExecutionConfigFromConfigurationTest.getOtherTestGlobalJobParameters()), TestSpec.testValue(64).whenSetFromFile("pipeline.max-parallelism", "64").viaSetter(ExecutionConfig::setMaxParallelism).getterVia(ExecutionConfig::getMaxParallelism).nonDefaultValue(13), TestSpec.testValue(true).whenSetFromFile("pipeline.object-reuse", "true").viaSetter(ExecutionConfigFromConfigurationTest.booleanSetter(ExecutionConfig::enableObjectReuse, ExecutionConfig::disableObjectReuse)).getterVia(ExecutionConfig::isObjectReuseEnabled).nonDefaultValue(true), TestSpec.testValue(true).whenSetFromFile("execution.checkpointing.snapshot-compression", "true").viaSetter(ExecutionConfig::setUseSnapshotCompression).getterVia(ExecutionConfig::isUseSnapshotCompression).nonDefaultValue(true), TestSpec.testValue(12).whenSetFromFile("parallelism.default", "12").viaSetter(ExecutionConfig::setParallelism).getterVia(ExecutionConfig::getParallelism).nonDefaultValue(21), TestSpec.testValue(12000L).whenSetFromFile("task.cancellation.interval", "12000").viaSetter(ExecutionConfig::setTaskCancellationInterval).getterVia(ExecutionConfig::getTaskCancellationInterval).nonDefaultValue(21L), TestSpec.testValue(12100L).whenSetFromFile("task.cancellation.timeout", "12100").viaSetter(ExecutionConfig::setTaskCancellationTimeout).getterVia(ExecutionConfig::getTaskCancellationTimeout).nonDefaultValue(21L), TestSpec.testValue(12300L).whenSetFromFile("metrics.latency.interval", "12300").viaSetter(ExecutionConfig::setLatencyTrackingInterval).getterVia(ExecutionConfig::getLatencyTrackingInterval).nonDefaultValue(21L));
    }

    @TestTemplate
    void testLoadingFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        ExecutionConfig configFromFile = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString(this.spec.key, this.spec.value);
        configFromFile.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        this.spec.setValue(configFromSetters);
        this.spec.assertEqual(configFromFile, configFromSetters);
    }

    @TestTemplate
    void testNotOverridingIfNotSet() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        this.spec.setNonDefaultValue(executionConfig);
        Configuration configuration = new Configuration();
        executionConfig.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        this.spec.assertEqualNonDefault(executionConfig);
    }

    private static ExecutionConfig.GlobalJobParameters getTestGlobalJobParameters() {
        Configuration globalJobParameters = new Configuration();
        globalJobParameters.setString("key1", "value1");
        globalJobParameters.setString("key2", "value2");
        return globalJobParameters;
    }

    private static ExecutionConfig.GlobalJobParameters getOtherTestGlobalJobParameters() {
        Configuration globalJobParameters = new Configuration();
        globalJobParameters.setString("key1", "value1");
        globalJobParameters.setString("key2", "value2");
        globalJobParameters.setString("key3", "value3");
        return globalJobParameters;
    }

    private static BiConsumer<ExecutionConfig, Boolean> booleanSetter(Consumer<ExecutionConfig> enable, Consumer<ExecutionConfig> disable) {
        return (execConfig, value) -> {
            if (value.booleanValue()) {
                enable.accept((ExecutionConfig)execConfig);
            } else {
                disable.accept((ExecutionConfig)execConfig);
            }
        };
    }

    private static class TestSpec<T> {
        private String key;
        private String value;
        private final T objectValue;
        private T nonDefaultValue;
        private BiConsumer<ExecutionConfig, T> setter;
        private Function<ExecutionConfig, T> getter;

        private TestSpec(T value) {
            this.objectValue = value;
        }

        public static <T> TestSpec<T> testValue(T value) {
            return new TestSpec<T>(value);
        }

        public TestSpec<T> whenSetFromFile(String key, String value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public TestSpec<T> viaSetter(BiConsumer<ExecutionConfig, T> setter) {
            this.setter = setter;
            return this;
        }

        public TestSpec<T> getterVia(Function<ExecutionConfig, T> getter) {
            this.getter = getter;
            return this;
        }

        public TestSpec<T> nonDefaultValue(T nonDefaultValue) {
            this.nonDefaultValue = nonDefaultValue;
            return this;
        }

        public void setValue(ExecutionConfig config) {
            this.setter.accept(config, (ExecutionConfig)this.objectValue);
        }

        public void setNonDefaultValue(ExecutionConfig config) {
            this.setter.accept(config, (ExecutionConfig)this.nonDefaultValue);
        }

        public void assertEqual(ExecutionConfig configFromFile, ExecutionConfig configFromSetters) {
            Assertions.assertThat(this.getter.apply(configFromSetters)).isEqualTo(this.getter.apply(configFromFile));
        }

        public void assertEqualNonDefault(ExecutionConfig configFromFile) {
            Assertions.assertThat(this.getter.apply(configFromFile)).isEqualTo(this.nonDefaultValue);
        }

        public String toString() {
            return "key='" + this.key + '\'';
        }
    }
}

