/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.function;

import java.util.function.Consumer;
import org.apache.flink.annotation.Public;
import org.apache.flink.util.function.ThrowingExceptionUtils;

@FunctionalInterface
@Public
public interface ThrowingConsumer<T, E extends Throwable> {
    public void accept(T var1) throws E;

    public static <A> Consumer<A> unchecked(ThrowingConsumer<A, ?> throwingConsumer) {
        return a -> {
            try {
                throwingConsumer.accept(a);
            }
            catch (Throwable t) {
                ThrowingExceptionUtils.rethrow(t);
            }
        };
    }
}

