/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.wikiedits;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.streaming.connectors.wikiedits.WikipediaEditEvent;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WikipediaEditEventIrcStream
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(WikipediaEditEventIrcStream.class);
    private final BlockingQueue<WikipediaEditEvent> edits = new ArrayBlockingQueue<WikipediaEditEvent>(128);
    private IRCConnection conn;

    WikipediaEditEventIrcStream(String host, int port) {
        String nick = "flink-bot-" + UUID.randomUUID().toString();
        this.conn = new IRCConnection(host, new int[]{port}, "", nick, nick, nick);
        this.conn.addIRCEventListener((IRCEventListener)new WikipediaIrcChannelListener(this.edits));
        this.conn.setEncoding("UTF-8");
        this.conn.setPong(true);
        this.conn.setColors(false);
        this.conn.setDaemon(true);
        this.conn.setName("WikipediaEditEventIrcStreamThread");
    }

    BlockingQueue<WikipediaEditEvent> getEdits() {
        return this.edits;
    }

    void connect() throws IOException {
        if (!this.conn.isConnected()) {
            this.conn.connect();
        }
    }

    void join(String channel) {
        Objects.requireNonNull(channel, "channel");
        this.conn.send("JOIN " + channel);
    }

    void leave(String channel) {
        this.conn.send("PART " + channel);
    }

    @Override
    public void close() throws Exception {
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.doQuit();
            this.conn.close();
            this.conn.join(5000L);
        }
    }

    private static class WikipediaIrcChannelListener
    implements IRCEventListener {
        private final BlockingQueue<WikipediaEditEvent> edits;

        WikipediaIrcChannelListener(BlockingQueue<WikipediaEditEvent> edits) {
            this.edits = Objects.requireNonNull(edits, "edits");
        }

        public void onPrivmsg(String target, IRCUser user, String msg) {
            LOG.debug("[{}] {}: {}.", new Object[]{target, user.getNick(), msg});
            WikipediaEditEvent event = WikipediaEditEvent.fromRawEvent(System.currentTimeMillis(), target, msg);
            if (event != null && !this.edits.offer(event)) {
                LOG.debug("Dropping message, because of full queue.");
            }
        }

        public void onRegistered() {
            LOG.debug("Connected.");
        }

        public void onDisconnected() {
            LOG.debug("Disconnected.");
        }

        public void onError(String msg) {
            LOG.error("Error: '{}'.", (Object)msg);
        }

        public void onError(int num, String msg) {
            LOG.error("Error #{}: '{}'.", (Object)num, (Object)msg);
        }

        public void onInvite(String chan, IRCUser user, String passiveNick) {
            LOG.debug("[{}]: {} invites {}.", new Object[]{chan, user.getNick(), passiveNick});
        }

        public void onJoin(String chan, IRCUser user) {
            LOG.debug("[{}]: {} joins.", (Object)chan, (Object)user.getNick());
        }

        public void onKick(String chan, IRCUser user, String passiveNick, String msg) {
            LOG.debug("[{}]: {} kicks {}.", new Object[]{chan, user.getNick(), passiveNick});
        }

        public void onMode(String chan, IRCUser user, IRCModeParser modeParser) {
            LOG.debug("[{}]: mode '{}'.", (Object)chan, (Object)modeParser.getLine());
        }

        public void onMode(IRCUser user, String passiveNick, String mode) {
            LOG.debug("{} sets modes {} ({}).", new Object[]{user.getNick(), mode, passiveNick});
        }

        public void onNick(IRCUser user, String newNick) {
            LOG.debug("{} is now known as {}.", (Object)user.getNick(), (Object)newNick);
        }

        public void onNotice(String target, IRCUser user, String msg) {
            LOG.debug("[{}] {} (notice): {}.", new Object[]{target, user.getNick(), msg});
        }

        public void onPart(String chan, IRCUser user, String msg) {
            LOG.debug("[{}] {} parts {}.", new Object[]{chan, user.getNick(), msg});
        }

        public void onPing(String ping) {
        }

        public void onQuit(IRCUser user, String msg) {
            LOG.debug("Quit: {}.", (Object)user.getNick());
        }

        public void onReply(int num, String value, String msg) {
            LOG.debug("Reply #{}: {} {}.", new Object[]{num, value, msg});
        }

        public void onTopic(String chan, IRCUser user, String topic) {
            LOG.debug("[{}] {} changes topic into {}.", new Object[]{chan, user.getNick(), topic});
        }

        public void unknown(String prefix, String command, String middle, String trailing) {
            LOG.warn("UNKNOWN: " + prefix + " " + command + " " + middle + " " + trailing);
        }
    }
}

