/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.twitter;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.json.JSONParseFlatMap;
import org.apache.flink.streaming.connectors.twitter.TwitterSource;
import org.apache.flink.util.Collector;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterStreaming {
    private static final int PARALLELISM = 1;
    private static final int SOURCE_PARALLELISM = 1;
    private static final int NUMBEROFTWEETS = 100;
    private static final Logger LOG = LoggerFactory.getLogger(TwitterStreaming.class);

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            System.err.println("USAGE:\nTwitterStreaming <pathToPropertiesFile>");
            return;
        }
        String path = args[0];
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)1);
        DataStreamSource streamSource = env.addSource((SourceFunction)new TwitterSource(path, 100)).setParallelism(1);
        SingleOutputStreamOperator selectedDataStream = streamSource.flatMap((FlatMapFunction)new SelectDataFlatMap());
        selectedDataStream.addSink((SinkFunction)new TwitterSink());
        env.execute();
    }

    public static class SelectDataFlatMap
    extends JSONParseFlatMap<String, Tuple5<Long, Integer, String, String, String>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<Tuple5<Long, Integer, String, String, String>> out) throws Exception {
            block2: {
                try {
                    out.collect((Object)new Tuple5((Object)this.getLong(value, "id"), (Object)this.getInt(value, "entities.hashtags[0].indices[1]"), (Object)this.getString(value, "lang"), (Object)this.getString(value, "text"), (Object)this.getString(value, "user.name")));
                }
                catch (JSONException e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error("Field not found");
                }
            }
        }
    }

    public static class TwitterSink
    implements SinkFunction<Tuple5<Long, Integer, String, String, String>> {
        private static final long serialVersionUID = 1L;

        public void invoke(Tuple5<Long, Integer, String, String, String> tuple) {
            System.out.println("ID: " + tuple.f0 + " int: " + tuple.f1 + " LANGUAGE: " + (String)tuple.f2);
            System.out.println("NAME: " + (String)tuple.f4);
            System.out.println("TEXT: " + (String)tuple.f3);
            System.out.println("");
        }
    }
}

