/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.twitter;

import com.twitter.hbc.core.endpoint.Location;
import com.twitter.hbc.core.endpoint.StatusesFilterEndpoint;
import com.twitter.hbc.httpclient.auth.OAuth1;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.streaming.connectors.twitter.TwitterSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterFilterSource
extends TwitterSource {
    private static final Logger LOG = LoggerFactory.getLogger(TwitterFilterSource.class);
    private static final long serialVersionUID = 1L;
    private List<String> trackTerms = new LinkedList<String>();
    private List<String> languages = new LinkedList<String>();
    private List<Long> followings = new LinkedList<Long>();
    private List<Location> locations = new LinkedList<Location>();
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private Map<String, String> postParameters = new HashMap<String, String>();

    public TwitterFilterSource(String authPath) {
        super(authPath);
    }

    @Override
    protected void initializeConnection() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initializing Twitter Streaming API connection");
        }
        this.queue = new LinkedBlockingQueue(this.queueSize);
        StatusesFilterEndpoint endpoint = new StatusesFilterEndpoint();
        this.configEndpoint(endpoint);
        endpoint.stallWarnings(false);
        OAuth1 auth = this.authenticate();
        this.initializeClient(endpoint, auth);
        if (LOG.isInfoEnabled()) {
            LOG.info("Twitter Streaming API connection established successfully");
        }
    }

    private void configEndpoint(StatusesFilterEndpoint endpoint) {
        if (!this.trackTerms.isEmpty()) {
            endpoint.trackTerms(this.trackTerms);
        }
        if (!this.languages.isEmpty()) {
            endpoint.languages(this.languages);
        }
        if (!this.followings.isEmpty()) {
            endpoint.followings(this.followings);
        }
        if (!this.locations.isEmpty()) {
            endpoint.locations(this.locations);
        }
        if (!this.queryParameters.isEmpty()) {
            for (Map.Entry<String, String> entry : this.queryParameters.entrySet()) {
                endpoint.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (!this.postParameters.isEmpty()) {
            for (Map.Entry<String, String> entry : this.postParameters.entrySet()) {
                endpoint.addPostParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void trackTerm(String term) {
        this.trackTerms.add(term);
    }

    public void trackTerms(Collection<String> terms) {
        this.trackTerms.addAll(terms);
    }

    public List<String> getTrackTerms() {
        return this.trackTerms;
    }

    public void filterLanguage(String language) {
        this.languages.add(language);
    }

    public void filterLanguages(Collection<String> languages) {
        this.languages.addAll(languages);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void filterFollowings(Long userID) {
        this.followings.add(userID);
    }

    public void filterFollowings(Collection<Long> userIDs) {
        this.followings.addAll(userIDs);
    }

    public List<Long> getFollowings() {
        return this.followings;
    }

    public void filterLocation(Location location) {
        this.locations.add(location);
    }

    public void filterLocations(Collection<Location> locations) {
        this.locations.addAll(locations);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public void addQueryParameter(String parameter, String value) {
        this.queryParameters.put(parameter, value);
    }

    public void addQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters.putAll(queryParameters);
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void addPostParameter(String parameter, String value) {
        this.postParameters.put(parameter, value);
    }

    public void addPostParameters(Map<String, String> postParameters) {
        this.postParameters.putAll(postParameters);
    }

    public Map<String, String> postParameters() {
        return this.postParameters;
    }
}

