/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth.keyvalue;

import com.twitter.joauth.Request;
import com.twitter.joauth.keyvalue.KeyValueHandler;
import java.util.List;

public interface KeyValueParser {
    public static final KeyValueParser HeaderKeyValueParser = new StandardKeyValueParser("\\s*,\\s*", "\\s*=\\s*");
    public static final KeyValueParser QueryKeyValueParser = new StandardKeyValueParser("&", "=");

    public void parse(String var1, List<KeyValueHandler> var2);

    public static class ConstKeyValueParser
    implements KeyValueParser {
        private final List<Request.Pair> pairs;

        public ConstKeyValueParser(List<Request.Pair> pairs) {
            this.pairs = pairs;
        }

        @Override
        public void parse(String input, List<KeyValueHandler> handlers) {
            for (Request.Pair pair : this.pairs) {
                for (KeyValueHandler handler : handlers) {
                    handler.handle(pair.key, pair.value);
                }
            }
        }
    }

    public static class StandardKeyValueParser
    implements KeyValueParser {
        private final String delimiter;
        private final String kvDelimiter;

        public StandardKeyValueParser(String delimiter, String kvDelimiter) {
            this.delimiter = delimiter;
            this.kvDelimiter = kvDelimiter;
        }

        @Override
        public void parse(String input, List<KeyValueHandler> handlers) {
            String[] tokens;
            if (this.empty(input)) {
                return;
            }
            block4: for (String token : tokens = input.split(this.delimiter)) {
                String[] keyAndValue = token.split(this.kvDelimiter);
                switch (keyAndValue.length) {
                    case 2: {
                        if (this.empty(keyAndValue[0])) continue block4;
                        for (KeyValueHandler handler : handlers) {
                            handler.handle(keyAndValue[0], keyAndValue[1]);
                        }
                        continue block4;
                    }
                    case 1: {
                        if (this.empty(keyAndValue[0])) continue block4;
                        for (KeyValueHandler handler : handlers) {
                            handler.handle(keyAndValue[0], "");
                        }
                        continue block4;
                    }
                }
            }
        }

        private boolean empty(String str) {
            return str == null || str.length() == 0;
        }
    }
}

