/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.Base64Util;
import com.twitter.joauth.UrlCodec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class Signer {
    private static final Signer STANDARD_SIGNER = new StandardSigner();

    public abstract String getString(String var1, String var2, String var3) throws InvalidKeyException, NoSuchAlgorithmException;

    public abstract byte[] getBytes(String var1, String var2, String var3) throws NoSuchAlgorithmException, InvalidKeyException;

    public abstract byte[] toBytes(String var1) throws UnsupportedEncodingException;

    public static Signer getStandardSigner() {
        return STANDARD_SIGNER;
    }

    public static class ConstSigner
    extends Signer {
        private final String str;
        private final byte[] bytes;

        public ConstSigner(String str, byte[] bytes) {
            this.str = str;
            this.bytes = bytes;
        }

        @Override
        public byte[] getBytes(String str, String tokenSecret, String consumerSecret) {
            return this.bytes;
        }

        @Override
        public String getString(String str, String tokenSecret, String consumerSecret) {
            return str;
        }

        @Override
        public byte[] toBytes(String signature) {
            return this.bytes;
        }
    }

    public static class StandardSigner
    extends Signer {
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private static final String AND = "&";
        private static final String HMACSHA1 = "HmacSHA1";

        @Override
        public String getString(String str, String tokenSecret, String consumerSecret) throws InvalidKeyException, NoSuchAlgorithmException {
            return UrlCodec.encode(Base64Util.encode(this.getBytes(str, tokenSecret, consumerSecret)));
        }

        @Override
        public byte[] getBytes(String str, String tokenSecret, String consumerSecret) throws NoSuchAlgorithmException, InvalidKeyException {
            String key = consumerSecret + AND + tokenSecret;
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(UTF_8), HMACSHA1);
            Mac mac = Mac.getInstance(HMACSHA1);
            mac.init(signingKey);
            return mac.doFinal(str.getBytes(UTF_8));
        }

        @Override
        public byte[] toBytes(String signature) throws UnsupportedEncodingException {
            return Base64Util.decode(UrlCodec.decode(signature).trim());
        }
    }
}

