/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.httpclient.auth;

import com.twitter.hbc.httpclient.auth.Authentication;
import com.twitter.joauth.Normalizer;
import com.twitter.joauth.OAuthParams;
import com.twitter.joauth.Request;
import com.twitter.joauth.Signer;
import com.twitter.joauth.UrlCodec;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.shaded.com.google.common.base.Charsets;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.AbstractHttpClient;

public class OAuth1
implements Authentication {
    private final Normalizer normalizer;
    private final Signer signer;
    private final String consumerKey;
    private final String consumerSecret;
    private final String token;
    private final String tokenSecret;
    private final SecureRandom secureRandom;

    public OAuth1(String consumerKey, String consumerSecret, String token, String tokenSecret) {
        this.consumerKey = Preconditions.checkNotNull(consumerKey);
        this.consumerSecret = Preconditions.checkNotNull(consumerSecret);
        this.token = Preconditions.checkNotNull(token);
        this.tokenSecret = Preconditions.checkNotNull(tokenSecret);
        this.normalizer = Normalizer.getStandardNormalizer();
        this.signer = Signer.getStandardSigner();
        this.secureRandom = new SecureRandom();
    }

    @Override
    public void setupConnection(AbstractHttpClient client) {
    }

    @Override
    public void signRequest(HttpUriRequest request, String postParams) {
        String signature;
        List httpGetParams = URLEncodedUtils.parse((String)request.getURI().getRawQuery(), (Charset)Charsets.UTF_8);
        ArrayList<Request.Pair> javaParams = new ArrayList<Request.Pair>(httpGetParams.size());
        for (NameValuePair params : httpGetParams) {
            Request.Pair tuple = new Request.Pair(UrlCodec.encode(params.getName()), UrlCodec.encode(params.getValue()));
            javaParams.add(tuple);
        }
        if (postParams != null) {
            List httpPostParams = URLEncodedUtils.parse((String)postParams, (Charset)Charsets.UTF_8);
            for (NameValuePair params : httpPostParams) {
                Request.Pair tuple = new Request.Pair(UrlCodec.encode(params.getName()), UrlCodec.encode(params.getValue()));
                javaParams.add(tuple);
            }
        }
        long timestampSecs = this.generateTimestamp();
        String nonce = this.generateNonce();
        OAuthParams.OAuth1Params oAuth1Params = new OAuthParams.OAuth1Params(this.token, this.consumerKey, nonce, timestampSecs, Long.toString(timestampSecs), "", "HMAC-SHA1", "1.0");
        int port = request.getURI().getPort();
        if (port <= 0) {
            if (request.getURI().getScheme().equalsIgnoreCase("http")) {
                port = 80;
            } else if (request.getURI().getScheme().equalsIgnoreCase("https")) {
                port = 443;
            } else {
                throw new IllegalStateException("Bad URI scheme: " + request.getURI().getScheme());
            }
        }
        String normalized = this.normalizer.normalize(request.getURI().getScheme(), request.getURI().getHost(), port, request.getMethod().toUpperCase(), request.getURI().getPath(), javaParams, oAuth1Params);
        try {
            signature = this.signer.getString(normalized, this.tokenSecret, this.consumerSecret);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> oauthHeaders = new HashMap<String, String>();
        oauthHeaders.put("oauth_consumer_key", this.quoted(this.consumerKey));
        oauthHeaders.put("oauth_token", this.quoted(this.token));
        oauthHeaders.put("oauth_signature", this.quoted(signature));
        oauthHeaders.put("oauth_signature_method", this.quoted("HMAC-SHA1"));
        oauthHeaders.put("oauth_timestamp", this.quoted(Long.toString(timestampSecs)));
        oauthHeaders.put("oauth_nonce", this.quoted(nonce));
        oauthHeaders.put("oauth_version", this.quoted("1.0"));
        String header = Joiner.on(", ").withKeyValueSeparator("=").join(oauthHeaders);
        request.setHeader("Authorization", "OAuth " + header);
    }

    private String quoted(String str) {
        return "\"" + str + "\"";
    }

    private long generateTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp / 1000L;
    }

    private String generateNonce() {
        return Long.toString(Math.abs(this.secureRandom.nextLong())) + System.currentTimeMillis();
    }
}

