/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.httpclient;

import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import com.twitter.hbc.httpclient.RestartableHttpClient;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.io.Closeables;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

public class Connection {
    private final HttpClient client;
    private HttpResponse response;
    private HttpUriRequest request;
    private InputStream stream;
    private final HosebirdMessageProcessor processor;

    public Connection(HttpClient client, HosebirdMessageProcessor processor) {
        this.client = Preconditions.checkNotNull(client);
        this.processor = Preconditions.checkNotNull(processor);
    }

    public StatusLine connect(HttpUriRequest request) throws IOException {
        this.request = request;
        this.response = this.client.execute(request);
        this.stream = this.response.getEntity().getContent();
        this.processor.setup(this.stream);
        return this.response.getStatusLine();
    }

    public boolean processResponse() throws IOException, InterruptedException {
        return this.processor.process();
    }

    public void close() {
        if (this.request != null && !this.request.isAborted()) {
            this.request.abort();
        }
        if (this.client instanceof RestartableHttpClient) {
            ((RestartableHttpClient)this.client).restart();
        }
        try {
            Closeables.close(this.stream, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

